/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.panel;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.ui.widget.AbstractPanel;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.panel.SwitchPanelHandler;

@Component(value="ui-switchpanel")
@UplAttributes(value={@UplAttribute(name="switchHandler", type=String.class)})
public class SwitchPanel
extends AbstractPanel {
    private String currentComponent;
    private SwitchPanelHandler switchPanelHandler;

    @Override
    public void onPageConstruct() throws UnifyException {
        super.onPageConstruct();
        String switchHandlerName = (String)this.getUplAttribute(String.class, "switchHandler");
        if (StringUtils.isNotBlank((String)switchHandlerName)) {
            this.switchPanelHandler = (SwitchPanelHandler)this.getComponent(switchHandlerName);
        }
        for (String longName : this.getLayoutWidgetLongNames()) {
            Widget widget = this.getWidgetByLongName(longName);
            if (widget.isHidden()) continue;
            this.currentComponent = widget.getShortName();
            break;
        }
    }

    public void switchContent(String shortName) throws UnifyException {
        if (this.switchPanelHandler != null) {
            this.switchPanelHandler.handleSwitchContent(this, shortName, this.getValueStore(), !shortName.equals(this.currentComponent));
        }
        this.currentComponent = shortName;
    }

    public void setSwitchPanelHandler(SwitchPanelHandler switchPanelHandler) {
        this.switchPanelHandler = switchPanelHandler;
    }

    public String getCurrentWidgetShortName() throws UnifyException {
        return this.currentComponent;
    }

    public Widget getCurrentWidget() throws UnifyException {
        if (this.currentComponent != null) {
            return this.getWidgetByShortName(this.currentComponent);
        }
        return null;
    }
}

