/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.panel;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.core.annotation.UplBinding;
import com.tcdng.unify.web.annotation.Action;
import com.tcdng.unify.web.ui.widget.Container;
import com.tcdng.unify.web.ui.widget.Control;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.panel.SwitchPanel;
import com.tcdng.unify.web.ui.widget.panel.TabPosition;
import java.util.ArrayList;
import java.util.List;

@Component(value="ui-tabbedpanel")
@UplBinding(value="web/panels/upl/tabbedpanel.upl")
@UplAttributes(value={@UplAttribute(name="tabPosition", type=TabPosition.class, defaultVal="top")})
public class TabbedPanel
extends SwitchPanel {
    private String activeTabId;

    @Override
    public void onPageConstruct() throws UnifyException {
        super.onPageConstruct();
        this.setComponentValueBeanToThis("selectedTabId");
        this.setDefaultActive();
    }

    @Override
    @Action
    public void switchState() throws UnifyException {
        super.switchState();
        Widget widget = this.getWidgetByLongName(this.getPageManager().getLongName(this.activeTabId));
        if (!widget.isVisible()) {
            widget = this.setDefaultActive();
        }
        this.switchContent(widget.getShortName());
    }

    public TabPosition getTabPosition() throws UnifyException {
        return (TabPosition)((Object)this.getUplAttribute(TabPosition.class, "tabPosition"));
    }

    public String getSelectedTabId() throws UnifyException {
        return this.getWidgetByShortName("selectedTabId").getId();
    }

    public String getActiveTabId() throws UnifyException {
        return this.activeTabId;
    }

    public void setActiveTabId(String activeTabPageName) {
        this.activeTabId = activeTabPageName;
    }

    private Widget setDefaultActive() throws UnifyException {
        for (String longName : this.getLayoutWidgetLongNames()) {
            Widget widget = this.getWidgetByLongName(longName);
            if (widget.isHidden() || !widget.isVisible()) continue;
            this.activeTabId = widget.getId();
            return widget;
        }
        return null;
    }

    public List<String> getActiveTabExpandedIdList() throws UnifyException {
        Widget widget = this.getCurrentWidget();
        if (widget instanceof Container) {
            return this.getPageManager().getPageNames(((Container)widget).getWidgetLongNames());
        }
        ArrayList<String> resultList = new ArrayList<String>();
        resultList.add(widget.getId());
        return resultList;
    }

    public List<String> getTabIds() throws UnifyException {
        ArrayList<String> resultList = new ArrayList<String>();
        for (String longName : this.getLayoutWidgetLongNames()) {
            Widget widget = this.getWidgetByLongName(longName);
            if (widget.isHidden()) continue;
            resultList.add(widget.getId());
        }
        return resultList;
    }

    public Control getSelectedTabIdCtrl() throws UnifyException {
        return (Control)this.getWidgetByShortName("selectedTabId");
    }
}

