/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.panel;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.UplBinding;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.annotation.Action;
import com.tcdng.unify.web.ui.widget.AbstractPanel;
import com.tcdng.unify.web.ui.widget.data.TaskMonitorInfo;

@Component(value="ui-taskmonitorpanel")
@UplBinding(value="web/panels/upl/taskmonitorpanel.upl")
public class TaskMonitorPanel
extends AbstractPanel {
    @Override
    @Action
    public void switchState() throws UnifyException {
        super.switchState();
        TaskMonitorInfo taskMonitorInfo = this.getValue(TaskMonitorInfo.class);
        if (taskMonitorInfo != null) {
            boolean isBusy = taskMonitorInfo.getTaskState() == 0;
            this.getWidgetByShortName("cancelBtn").setVisible(isBusy);
            this.getWidgetByShortName("doneBtn").setVisible(!isBusy);
            this.setAllowRefresh(isBusy);
        }
    }

    @Action
    public void cancelTask() throws UnifyException {
        TaskMonitorInfo taskMonitorInfo = this.getValue(TaskMonitorInfo.class);
        taskMonitorInfo.cancelTask();
        this.commandHidePopup();
    }

    @Action
    public void taskDone() throws UnifyException {
        TaskMonitorInfo taskMonitorInfo = this.getValue(TaskMonitorInfo.class);
        String taskDonePath = null;
        if (taskMonitorInfo.getTaskState() == 1) {
            taskDonePath = taskMonitorInfo.getOnSuccessPath();
        } else if (taskMonitorInfo.getTaskState() == 2 || taskMonitorInfo.getTaskState() == 3) {
            taskDonePath = taskMonitorInfo.getOnFailurePath();
        }
        if (StringUtils.isNotBlank((String)taskDonePath)) {
            this.commandPost(taskDonePath);
        } else {
            this.commandHidePopup();
        }
    }
}

