/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.validation;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.web.ui.DataTransfer;
import com.tcdng.unify.web.ui.DataTransferBlock;
import com.tcdng.unify.web.ui.widget.AbstractPageValidation;
import com.tcdng.unify.web.ui.widget.Control;
import com.tcdng.unify.web.ui.widget.Widget;
import java.util.List;

public abstract class AbstractComparisonPageValidation
extends AbstractPageValidation {
    private String validationCode;
    private boolean validateSame;

    public AbstractComparisonPageValidation(String validationCode, boolean validateSame) {
        this.validationCode = validationCode;
        this.validateSame = validateSame;
    }

    @Override
    public boolean validate(List<Widget> widgets, DataTransfer dataTransfer) throws UnifyException {
        DataTransferBlock transferBlock1 = dataTransfer.getDataTransferBlock(widgets.get(0).getId());
        DataTransferBlock transferBlock2 = dataTransfer.getDataTransferBlock(widgets.get(1).getId());
        if (transferBlock1 != null && transferBlock2 != null) {
            String value1 = this.getTransferValue(String.class, transferBlock1);
            String value2 = this.getTransferValue(String.class, transferBlock2);
            if (value1 != null && value2 != null && this.validateSame != value1.equals(value2)) {
                String caption1 = (String)widgets.get(0).getUplAttribute(String.class, "caption");
                String caption2 = (String)widgets.get(1).getUplAttribute(String.class, "caption");
                String message = null;
                message = this.validateSame ? this.getSessionMessage("validation.notsame", new Object[]{caption1, caption2}) : this.getSessionMessage("validation.same", new Object[]{caption1, caption2});
                this.addValidationFail((Control)widgets.get(0), this.validationCode, message);
                return false;
            }
        }
        this.addValidationPass((Control)widgets.get(0), this.validationCode);
        return true;
    }
}

