/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.validation;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.ui.DataTransfer;
import com.tcdng.unify.web.ui.DataTransferBlock;
import com.tcdng.unify.web.ui.widget.AbstractPageValidation;
import com.tcdng.unify.web.ui.widget.Control;
import com.tcdng.unify.web.ui.widget.PageManager;
import com.tcdng.unify.web.ui.widget.Section;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.container.Form;
import com.tcdng.unify.web.ui.widget.control.DynamicField;
import com.tcdng.unify.web.ui.widget.control.MultiDynamic;
import com.tcdng.unify.web.ui.widget.panel.DynamicPanel;
import com.tcdng.unify.web.ui.widget.panel.StandalonePanel;
import java.util.List;

@Component(value="ui-validation")
public class PageValidationImpl
extends AbstractPageValidation {
    @Override
    public boolean validate(List<Widget> widgets, DataTransfer dataTransfer) throws UnifyException {
        boolean pass = true;
        for (Widget widget : widgets) {
            if (!widget.isVisible()) continue;
            if (widget instanceof Form) {
                Form form = (Form)widget;
                Section[] sections = (Section[])form.getUplAttribute(Section[].class, "section");
                for (Section section : sections) {
                    List longNames = section.getShallowReferencedLongNames("components");
                    for (String longName : longNames) {
                        Widget frmWidget = form.getWidgetByLongName(longName);
                        if (!frmWidget.isVisible() || !(frmWidget instanceof Control)) continue;
                        pass &= this.validateWidget((Control)frmWidget, dataTransfer);
                    }
                }
                continue;
            }
            if (widget instanceof MultiDynamic) {
                List list;
                MultiDynamic multiDynamic = (MultiDynamic)widget;
                if (!multiDynamic.isContainerVisible() || !multiDynamic.isContainerEditable() || (list = multiDynamic.getValueList()) == null) continue;
                DynamicField valueCtrl = multiDynamic.getValueCtrl();
                for (DataTransferBlock dataTransferBlock = dataTransfer.getDataTransferBlock(multiDynamic.getId()); dataTransferBlock != null; dataTransferBlock = dataTransferBlock.getSiblingBlock()) {
                    String value;
                    boolean localPass = true;
                    DataTransferBlock dynamicCtrlBlock = dataTransferBlock.getChildBlock();
                    MultiDynamic.ValueStore store = (MultiDynamic.ValueStore)list.get(dynamicCtrlBlock.getChildBlock().getItemIndex());
                    valueCtrl.setValueStore(store.getValueStore());
                    Control control = valueCtrl.getControl();
                    if (store.isRequired() && ((value = this.getTransferValue(String.class, dynamicCtrlBlock.getChildBlock())) == null || StringUtils.isBlank((String)value))) {
                        this.addValidationFail(control, "required", this.getSessionMessage("validation.required", new Object[]{store.getCaption()}));
                        localPass = false;
                        pass = false;
                    }
                    if (!localPass) continue;
                    this.addValidationPass(control, null);
                }
                continue;
            }
            if (widget instanceof DynamicPanel) {
                PageManager pageManager = this.getPageManager();
                StandalonePanel standalonePanel = ((DynamicPanel)widget).getStandalonePanel();
                for (String longName : standalonePanel.getPageValidationNames()) {
                    pass &= standalonePanel.getPageWidgetValidator(pageManager, longName).validate(dataTransfer);
                }
                continue;
            }
            if (!(widget instanceof Control)) continue;
            pass &= this.validateWidget((Control)widget, dataTransfer);
        }
        return pass;
    }

    private boolean validateWidget(Control control, DataTransfer dataTransfer) throws UnifyException {
        DataTransferBlock dataTransferBlock = dataTransfer.getDataTransferBlock(control.getId());
        if (dataTransferBlock != null) {
            int maxLen;
            int minLen;
            String caption = (String)control.getUplAttribute(String.class, "caption");
            String value = this.getTransferValue(String.class, dataTransferBlock);
            if (control.getRequired().isTrue() && (value == null || StringUtils.isBlank((String)value))) {
                this.addValidationFail(control, "required", this.getSessionMessage("validation.required", new Object[]{caption}));
                return false;
            }
            if (control.isUplAttribute("minLen") && (minLen = ((Integer)control.getUplAttribute(Integer.TYPE, "minLen")).intValue()) > 0 && (value == null || value.length() < minLen)) {
                this.addValidationFail(control, "minLen", this.getSessionMessage("validation.greaterthanorequal", new Object[]{caption, minLen}));
                return false;
            }
            if (control.isUplAttribute("maxLen") && (maxLen = ((Integer)control.getUplAttribute(Integer.TYPE, "maxLen")).intValue()) > 0 && value != null && value.length() > maxLen) {
                this.addValidationFail(control, "maxLen", this.getSessionMessage("validation.lessthanorequal", new Object[]{caption, maxLen}));
                return false;
            }
            this.addValidationPass(control, null);
        }
        return true;
    }
}

