/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.validation;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.core.business.GenericService;
import com.tcdng.unify.core.database.Query;
import com.tcdng.unify.web.ui.DataTransfer;
import com.tcdng.unify.web.ui.DataTransferBlock;
import com.tcdng.unify.web.ui.widget.AbstractPageValidation;
import com.tcdng.unify.web.ui.widget.Control;
import com.tcdng.unify.web.ui.widget.Widget;
import java.util.List;

@Component(value="ui-uniquevalidation")
@UplAttributes(value={@UplAttribute(name="type", type=Class.class), @UplAttribute(name="idProperty", type=String.class, defaultVal="id"), @UplAttribute(name="idType", type=Class.class, defaultVal="java.lang.Long")})
public class UniqueValidation
extends AbstractPageValidation {
    @Override
    public boolean validate(List<Widget> widgets, DataTransfer dataTransfer) throws UnifyException {
        Class<?> idClazz;
        Class<?> validationClazz = (Class<?>)this.getUplAttribute(Class.class, "type");
        if (validationClazz == null) {
            validationClazz = dataTransfer.getValidationClass();
        }
        if ((idClazz = (Class<?>)this.getUplAttribute(Class.class, "idType")) == null) {
            idClazz = dataTransfer.getValidationIdClass();
        }
        if (validationClazz != null) {
            Query criteria = Query.of(validationClazz);
            String idProperty = (String)this.getUplAttribute(String.class, "idProperty");
            Object id = this.getTransferValue(idClazz, idProperty, dataTransfer);
            if (id != null) {
                criteria.addNotEquals("id", id);
            }
            StringBuilder sb = new StringBuilder();
            boolean appendSymbol = false;
            for (Widget widget : widgets) {
                Object value;
                if (!widget.isVisible() && !widget.isHidden()) continue;
                DataTransferBlock transferBlock = dataTransfer.getDataTransferBlock(widget.getId());
                if (transferBlock == null || (value = transferBlock.getValue()) == null) break;
                criteria.addEquals(transferBlock.getShortProperty(), value);
                if (appendSymbol) {
                    sb.append(',');
                } else {
                    appendSymbol = true;
                }
                String caption = (String)widget.getUplAttribute(String.class, "caption");
                sb.append(caption).append(" '").append(value).append('\'');
            }
            if (sb.length() > 0 && ((GenericService)this.getComponent("application-genericservice")).countAll(criteria) > 0) {
                String message = this.getSessionMessage("validation.uniquerecordexists", new Object[]{sb.toString()});
                this.addValidationFail((Control)widgets.get(0), "unique", message);
                return false;
            }
        }
        this.addValidationPass((Control)widgets.get(0), null);
        return true;
    }
}

