/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.validation;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.web.ui.DataTransfer;
import com.tcdng.unify.web.ui.DataTransferBlock;
import com.tcdng.unify.web.ui.widget.AbstractPageValidation;
import com.tcdng.unify.web.ui.widget.Control;
import com.tcdng.unify.web.ui.widget.Widget;
import java.util.List;

@Component(value="ui-upldescriptorvalidation")
public class UplDescriptorValidation
extends AbstractPageValidation {
    @Override
    public boolean validate(List<Widget> widgets, DataTransfer dataTransfer) throws UnifyException {
        boolean pass = true;
        for (Widget widget : widgets) {
            boolean localPass = true;
            DataTransferBlock transferBlock = dataTransfer.getDataTransferBlock(widget.getId());
            if (transferBlock != null) {
                try {
                    String descriptor = this.getTransferValue(String.class, transferBlock);
                    this.getUplComponent(this.getSessionLocale(), descriptor, false);
                }
                catch (Exception e) {
                    String caption = (String)widget.getUplAttribute(String.class, "caption");
                    String message = this.getSessionMessage("validation.invalidupldescriptor", new Object[]{caption});
                    this.addValidationFail((Control)widget, "upldescriptor", message);
                    localPass = false;
                    pass = false;
                }
            }
            if (!localPass) continue;
            this.addValidationPass((Control)widget, "upldescriptor");
        }
        return pass;
    }
}

