/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.web.ui.widget.Container;
import com.tcdng.unify.web.ui.widget.Layout;
import com.tcdng.unify.web.ui.widget.PushType;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.writer.AbstractWidgetWriter;
import com.tcdng.unify.web.ui.widget.writer.ContainerWriter;

public abstract class AbstractContainerWriter
extends AbstractWidgetWriter
implements ContainerWriter {
    @Override
    protected void doWriteStructureAndContent(ResponseWriter writer, Widget widget) throws UnifyException {
        Container container = (Container)widget;
        writer.write("<div");
        this.writeTagAttributes(writer, container);
        writer.write(">");
        this.writeLayoutContent(writer, container);
        writer.write("</div>");
    }

    @Override
    protected void doWriteBehavior(ResponseWriter writer, Widget widget) throws UnifyException {
        Container container = (Container)widget;
        super.doWriteBehavior(writer, container);
        this.writeContainedWidgetsBehavior(writer, container);
    }

    protected void writeLayoutContent(ResponseWriter writer, Container container) throws UnifyException {
        Layout layout = container.getLayout();
        if (container.isUseLayoutIfPresent() && layout != null) {
            writer.writeStructureAndContent(layout, container);
        } else {
            boolean isSpace = container.isSpace();
            boolean isAlternate = container.isAlternate();
            for (String longName : container.getLayoutWidgetLongNames()) {
                Widget widget = container.getWidgetByLongName(longName);
                widget.setAlternateMode(isAlternate);
                if (widget.isVisible()) {
                    writer.writeStructureAndContent(widget);
                    if (!isSpace) continue;
                    writer.writeHtmlFixedSpace();
                    continue;
                }
                if (!widget.isHidden()) continue;
                writer.writeStructureAndContent(widget);
            }
        }
    }

    protected void writeContainedWidgetsBehavior(ResponseWriter writer, Container container) throws UnifyException {
        boolean isAlternate = container.isAlternate();
        for (String longName : container.getLayoutWidgetLongNames()) {
            Widget widget = container.getWidgetByLongName(longName);
            if (!widget.isVisible() && !widget.isHidden() && !widget.isBehaviorAlways()) continue;
            widget.setAlternateMode(isAlternate);
            writer.writeBehavior(widget);
        }
    }

    protected void writeHiddenPush(ResponseWriter writer, Widget widget, PushType type) throws UnifyException {
        this.writeHidden(writer, widget.getId(), type.getPrefix());
    }

    protected void writeHiddenPush(ResponseWriter writer, String id, PushType type) throws UnifyException {
        this.writeHidden(writer, id, type.getPrefix());
    }

    protected void writeHidden(ResponseWriter writer, String id, Object value) throws UnifyException {
        writer.write("<input type=\"hidden\"");
        this.writeTagId(writer, id);
        this.writeTagValue(writer, value);
        writer.write("/>");
    }
}

