/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.web.ui.widget.Control;
import com.tcdng.unify.web.ui.widget.PushType;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.writer.AbstractWidgetWriter;
import com.tcdng.unify.web.ui.widget.writer.ControlWriter;

public abstract class AbstractControlWriter
extends AbstractWidgetWriter
implements ControlWriter {
    @Override
    protected void doWriteBehavior(ResponseWriter writer, Widget widget) throws UnifyException {
        super.doWriteBehavior(writer, widget);
        Control control = (Control)widget;
        if (control.isFocus()) {
            if (widget.isUseFacade()) {
                this.getRequestContextUtil().setFocusOnWidgetId(control.getFacadeId());
            } else {
                this.getRequestContextUtil().setFocusOnWidgetId(control.getId());
            }
        }
    }

    protected void writeHiddenPush(ResponseWriter writer, Widget widget, PushType type) throws UnifyException {
        this.writeHidden(writer, widget.getId(), type.getPrefix());
    }

    protected void writeHiddenPush(ResponseWriter writer, String id, PushType type) throws UnifyException {
        this.writeHidden(writer, id, type.getPrefix());
    }

    protected void writeHidden(ResponseWriter writer, String id, Object value) throws UnifyException {
        writer.write("<input type=\"hidden\"");
        this.writeTagId(writer, id);
        this.writeTagValue(writer, value);
        writer.write("/>");
    }

    protected void writeButton(ResponseWriter writer, String id, String styleClass, String style, String caption) throws UnifyException {
        writer.write("<button type=\"button\"");
        this.writeTagId(writer, id);
        if (styleClass != null) {
            this.writeTagStyleClass(writer, styleClass);
        }
        if (style != null) {
            this.writeTagStyle(writer, style);
        }
        writer.write(">");
        writer.writeWithHtmlEscape(caption);
        writer.write("</button>");
    }

    protected void writeValueAccessor(ResponseWriter writer, Widget widget) throws UnifyException {
        writer.write("ux.rigValueAccessor(\"").write(widget.getId()).write("\");");
    }

    protected void addPageAlias(String parentPageName, Widget widget) throws UnifyException {
        this.getRequestContextUtil().addPageAlias(parentPageName, widget.getId());
    }
}

