/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Configurable;
import com.tcdng.unify.core.constant.MimeType;
import com.tcdng.unify.core.data.ValueStore;
import com.tcdng.unify.core.upl.AbstractUplComponentWriter;
import com.tcdng.unify.core.upl.UplElementReferences;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.core.util.TokenUtils;
import com.tcdng.unify.web.ThemeManager;
import com.tcdng.unify.web.ui.PageRequestContextUtil;
import com.tcdng.unify.web.ui.util.WebUtils;
import com.tcdng.unify.web.ui.util.WriterUtils;
import com.tcdng.unify.web.ui.widget.PageAction;
import com.tcdng.unify.web.ui.widget.PageManager;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import java.util.List;

public abstract class AbstractDhtmlWriter
extends AbstractUplComponentWriter {
    @Configurable
    private ThemeManager themeManager;
    @Configurable
    private PageManager pageManager;

    public void setThemeManager(ThemeManager themeManager) {
        this.themeManager = themeManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    protected final void writeTagAttributes(ResponseWriter writer, Widget widget) throws UnifyException {
        this.writeTagAttributesUsingStyleClass(writer, widget, widget.getStyleClass());
    }

    protected final void writeTagAttributesWithLeadingExtraStyleClass(ResponseWriter writer, Widget widget, String extraStyleClass) throws UnifyException {
        this.writeTagAttributesUsingStyleClass(writer, widget, extraStyleClass + " " + widget.getStyleClass());
    }

    protected final void writeTagAttributesWithTrailingExtraStyleClass(ResponseWriter writer, Widget widget, String extraStyleClass) throws UnifyException {
        this.writeTagAttributesUsingStyleClass(writer, widget, widget.getStyleClass() + " " + extraStyleClass);
    }

    protected final void writeTagAttributesUsingStyleClass(ResponseWriter writer, Widget widget, String styleClass) throws UnifyException {
        String title;
        writer.write(" id=\"").write(widget.getId()).write("\"");
        String groupId = widget.getGroupId();
        if (groupId != null) {
            writer.write(" name=\"").write(groupId).write("\"");
        }
        writer.write(" class=\"").write(styleClass);
        String valStyleClass = widget.getStyleClassValue();
        if (valStyleClass != null) {
            writer.write(" ").write(valStyleClass);
        }
        writer.write("\"");
        String style = widget.getStyle();
        if (style != null) {
            writer.write(" style=\"").write(style).write("\"");
        }
        if ((title = widget.getHint()) != null) {
            writer.write(" title=\"").write(title).write("\"");
        }
        if (widget.isSupportDisabled() && (widget.isContainerDisabled() || !widget.isSupportReadOnly() && !widget.isContainerEditable())) {
            writer.write(" disabled");
        }
        if (widget.isSupportReadOnly() && !widget.isContainerEditable()) {
            writer.write(" readonly");
        }
    }

    protected final void writeTagIdentificationAttributes(ResponseWriter writer, Widget widget) throws UnifyException {
        writer.write(" id=\"").write(widget.getId()).write("\"");
        String groupId = widget.getGroupId();
        if (groupId != null) {
            writer.write(" name=\"").write(groupId).write("\"");
        }
    }

    protected final void writeTagVisualAttributes(ResponseWriter writer, Widget widget) throws UnifyException {
        this.writeTagVisualAttributesUsingStyleClass(writer, widget, widget.getStyleClass());
    }

    protected final void writeTagVisualAttributesWithLeadingExtraStyleClass(ResponseWriter writer, Widget widget, String extraStyleClass) throws UnifyException {
        this.writeTagVisualAttributesUsingStyleClass(writer, widget, extraStyleClass + " " + widget.getStyleClass());
    }

    protected final void writeTagVisualAttributesWithTrailingExtraStyleClass(ResponseWriter writer, Widget widget, String extraStyleClass) throws UnifyException {
        this.writeTagVisualAttributesUsingStyleClass(writer, widget, widget.getStyleClass() + " " + extraStyleClass);
    }

    protected final void writeTagVisualAttributesUsingStyleClass(ResponseWriter writer, Widget widget, String styleClass) throws UnifyException {
        String title;
        writer.write(" class=\"").write(styleClass);
        String valStyleClass = widget.getStyleClassValue();
        if (valStyleClass != null) {
            writer.write(" ").write(valStyleClass);
        }
        writer.write("\"");
        String style = widget.getStyle();
        if (style != null) {
            writer.write(" style=\"").write(style).write("\"");
        }
        if ((title = widget.getHint()) != null) {
            writer.write(" title=\"").write(title).write("\"");
        }
        if (widget.isSupportDisabled() && (widget.isContainerDisabled() || !widget.isSupportReadOnly() && !widget.isContainerEditable())) {
            writer.write(" disabled");
        }
        if (widget.isSupportReadOnly() && !widget.isContainerEditable()) {
            writer.write(" readonly");
        }
    }

    protected final void writeTagEditAttributes(ResponseWriter writer, Widget widget) throws UnifyException {
        if (widget.isContainerDisabled() || !widget.isSupportReadOnly() && !widget.isContainerEditable()) {
            writer.write(" disabled");
        }
        if (widget.isSupportReadOnly() && !widget.isContainerEditable()) {
            writer.write(" readonly");
        }
    }

    protected final void writeTagId(ResponseWriter writer, Widget widget) throws UnifyException {
        writer.write(" id=\"").write(widget.getId()).write("\"");
    }

    protected final void writeTagId(ResponseWriter writer, String id) throws UnifyException {
        writer.write(" id=\"").write(id).write("\"");
    }

    protected final void writeTagName(ResponseWriter writer, Widget widget) throws UnifyException {
        String name = widget.getGroupId();
        if (StringUtils.isNotBlank((String)name)) {
            writer.write(" name=\"").write(name).write("\"");
        }
    }

    protected final void writeTagName(ResponseWriter writer, String name) throws UnifyException {
        writer.write(" name=\"").write(name).write("\"");
    }

    protected final void writeTagStyleClass(ResponseWriter writer, Widget widget) throws UnifyException {
        writer.write(" class=\"").write(widget.getStyleClass());
        String valStyleClass = widget.getStyleClassValue();
        if (valStyleClass != null) {
            writer.write(" ").write(valStyleClass);
        }
        writer.write("\"");
    }

    @Deprecated
    protected final void writeTagStyleClass(ResponseWriter writer, Widget widget, boolean extraLeading, String ... extraClasses) throws UnifyException {
        writer.write(" class=\"");
        if (extraLeading) {
            for (String extraClass : extraClasses) {
                if (extraClass == null) continue;
                writer.write(extraClass).write(" ");
            }
            writer.write(widget.getStyleClass());
        } else {
            writer.write(widget.getStyleClass());
            for (String extraClass : extraClasses) {
                if (extraClass == null) continue;
                writer.write(" ").write(extraClass);
            }
        }
        String valStyleClass = widget.getStyleClassValue();
        if (valStyleClass != null) {
            writer.write(" ").write(valStyleClass);
        }
        writer.write("\"");
    }

    protected final void writeTagStyleClassWithLeadingExtraStyleClasses(ResponseWriter writer, Widget widget, String ... extraClasses) throws UnifyException {
        writer.write(" class=\"");
        for (String extraClass : extraClasses) {
            if (extraClass == null) continue;
            writer.write(extraClass).write(" ");
        }
        writer.write(widget.getStyleClass());
        String valStyleClass = widget.getStyleClassValue();
        if (valStyleClass != null) {
            writer.write(" ").write(valStyleClass);
        }
        writer.write("\"");
    }

    protected final void writeTagStyleClassWithTrailingExtraStyleClasses(ResponseWriter writer, Widget widget, String ... extraClasses) throws UnifyException {
        writer.write(" class=\"");
        writer.write(widget.getStyleClass());
        for (String extraClass : extraClasses) {
            if (extraClass == null) continue;
            writer.write(" ").write(extraClass);
        }
        String valStyleClass = widget.getStyleClassValue();
        if (valStyleClass != null) {
            writer.write(" ").write(valStyleClass);
        }
        writer.write("\"");
    }

    protected final void writeTagStyleClass(ResponseWriter writer, String styleClass) throws UnifyException {
        writer.write(" class=\"").write(styleClass).write("\"");
    }

    protected final void writeTagStyle(ResponseWriter writer, Widget widget) throws UnifyException {
        if (StringUtils.isNotBlank((String)widget.getStyle())) {
            writer.write(" style=\"").write(widget.getStyle()).write("\"");
        }
    }

    protected final void writeTagStyle(ResponseWriter writer, String style) throws UnifyException {
        if (StringUtils.isNotBlank((String)style)) {
            writer.write(" style=\"").write(style).write("\"");
        }
    }

    protected final void writeTagStyle(ResponseWriter writer, Widget widget, String style) throws UnifyException {
        if (StringUtils.isNotBlank((String)style) || StringUtils.isNotBlank((String)widget.getStyle())) {
            writer.write(" style=\"");
            if (StringUtils.isNotBlank((String)widget.getStyle())) {
                writer.write(widget.getStyle());
            }
            if (StringUtils.isNotBlank((String)style)) {
                writer.write(style);
            }
            writer.write("\"");
        }
    }

    protected final void writeTagTitle(ResponseWriter writer, Widget widget) throws UnifyException {
        if (StringUtils.isNotBlank((String)widget.getHint())) {
            writer.write(" title=\"").write(widget.getHint()).write("\"");
        }
    }

    protected final void writeTagTitle(ResponseWriter writer, String title) throws UnifyException {
        if (StringUtils.isNotBlank((String)title)) {
            writer.write(" title=\"").write(title).write("\"");
        }
    }

    protected final void writeTagValue(ResponseWriter writer, Widget widget) throws UnifyException {
        String value = widget.getStringValue();
        if (value != null) {
            writer.write(" value=\"").writeWithHtmlEscape(value).write("\"");
        }
    }

    protected final void writeTagValue(ResponseWriter writer, Object value) throws UnifyException {
        if (value != null) {
            writer.write(" value=\"").writeWithHtmlEscape(String.valueOf(value)).write("\"");
        }
    }

    protected final void writeTagReadOnly(ResponseWriter writer) throws UnifyException {
        writer.write(" readonly");
    }

    protected final void writeTagReadOnly(ResponseWriter writer, Widget widget) throws UnifyException {
        if (widget.isSupportReadOnly() && !widget.isContainerEditable()) {
            writer.write(" readonly");
        }
    }

    protected final void writeTagDisabled(ResponseWriter writer, Widget widget) throws UnifyException {
        if (widget.isContainerDisabled()) {
            writer.write(" disabled");
        }
    }

    protected final void writeTagId(StringBuilder sb, String id) throws UnifyException {
        sb.append(" id=\"").append(id).append("\"");
    }

    protected final void writeTagName(StringBuilder sb, String name) throws UnifyException {
        sb.append(" name=\"").append(name).append("\"");
    }

    protected final void writeTagStyleClass(StringBuilder sb, String styleClass) throws UnifyException {
        sb.append(" class=\"").append(styleClass).append("\"");
    }

    protected final void writeTagStyle(StringBuilder sb, String style) throws UnifyException {
        sb.append(" style=\"").append(style).append("\"");
    }

    protected final void writeTagTitle(StringBuilder sb, String title) throws UnifyException {
        sb.append(" title=\"").append(title).append("\"");
    }

    protected void writeFileImageHtmlElement(ResponseWriter writer, String src, String id, String styleClass, String style) throws UnifyException {
        writer.write("<img");
        if (StringUtils.isNotBlank((String)id)) {
            writer.write(" id=\"").write(id).write("\"");
        }
        if (StringUtils.isNotBlank((String)styleClass)) {
            writer.write(" class=\"").write(styleClass).write("\"");
        }
        if (StringUtils.isNotBlank((String)style)) {
            writer.write(" style=\"").write(style).write("\"");
        }
        writer.write(" src=\"");
        writer.writeContextResourceURL("/resource/file", MimeType.IMAGE.template(), this.themeManager.expandThemeTag(src));
        writer.write("\">");
    }

    protected boolean writeCaption(ResponseWriter writer, Widget widget) throws UnifyException {
        String caption = widget.getCaption();
        if (caption != null) {
            writer.writeWithHtmlEscape(caption);
            return true;
        }
        return false;
    }

    protected boolean writeAttributeWithEscape(ResponseWriter writer, Widget widget, String attribute) throws UnifyException {
        String cattributeValue = (String)widget.getUplAttribute(String.class, attribute);
        if (cattributeValue != null) {
            writer.writeWithHtmlEscape(cattributeValue);
            return true;
        }
        return false;
    }

    protected void writePostToPathJs(ResponseWriter writer, String path) throws UnifyException {
        writer.write(WriterUtils.getActionJSFunction("posttopath")).write("(\"");
        writer.writeContextURL(path, new String[0]);
        writer.write("\");");
    }

    protected void writeShortcutHandlerJs(ResponseWriter writer, String pageControllerName, String id, String cmdTag, PageAction pageAction) throws UnifyException {
        String function = WriterUtils.getActionJSFunction(pageAction.getAction().toLowerCase());
        String eventParams = this.writeActionParamsJS(writer, null, function, id, cmdTag, pageAction, null, null, null);
        String shortcut = (String)pageAction.getUplAttribute(String.class, "shortcut");
        writer.write("ux.setShortcut(\"").write(WebUtils.encodeShortcut(shortcut)).write("\",");
        writer.write(eventParams).write(");");
    }

    protected void writeEventJs(ResponseWriter writer, String event, String action, String pageName, String cmdTag, String ... targetPageNames) throws UnifyException {
        event = WriterUtils.getEventJS(event.toLowerCase());
        String function = WriterUtils.getActionJSFunction(action);
        String eventParams = this.writeActionParamsJS(writer, event, function, pageName, cmdTag, null, targetPageNames, null, null);
        writer.write("ux.setOnEvent(").write(eventParams).write(");");
    }

    protected void writePathEventHandlerJS(ResponseWriter writer, String id, String cmdTag, String eventType, String action, String path) throws UnifyException {
        String event = WriterUtils.getEventJS(eventType.toLowerCase());
        String function = WriterUtils.getActionJSFunction(action.toLowerCase());
        String eventParams = this.writeActionParamsJS(writer, event, function, id, cmdTag, null, null, null, path);
        writer.write("ux.setOnEvent(").write(eventParams).write(");");
    }

    protected void writeOpenPopupJS(ResponseWriter writer, String event, String pageName, String cmdTag, String frameId, String popupId, long stayOpenForMillSec, String onShowAction, String onShowParamObject, String onHideAction, String onHideParamObject) throws UnifyException {
        StringBuilder psb = new StringBuilder();
        psb.append("{\"popupId\":\"").append(popupId).append("\"");
        if (frameId != null) {
            psb.append(",\"frameId\":\"").append(frameId).append("\"");
        }
        psb.append(",\"stayOpenForMillSec\":").append(stayOpenForMillSec);
        if (onShowAction != null) {
            psb.append(",\"showHandler\":").append(WriterUtils.getActionJSFunctionOptional(onShowAction));
            if (onShowParamObject != null) {
                psb.append(",\"showParam\":").append(onShowParamObject);
            }
        }
        if (onHideAction != null) {
            psb.append(",\"hideHandler\":").append(WriterUtils.getActionJSFunctionOptional(onHideAction));
            if (onHideParamObject != null) {
                psb.append(",\"hideParam\":").append(onHideParamObject);
            }
        }
        psb.append("}");
        this.writeRefObjectEventHandlerJS(writer, pageName, cmdTag, event, "openpopup", psb.toString());
    }

    protected String writeActionParamsJS(ResponseWriter writer, String event, String function, String id, String cmdTag, PageAction pageAction, String[] refPageNames, String refObject, String path) throws UnifyException {
        String pathId = this.getRequestContextUtil().getResponsePathParts().getControllerPathId();
        PageManager pageManager = this.getPageManager();
        String eventParams = "_act" + WriterUtils.getNextRefId() + "Prm";
        writer.write("var ").write(eventParams).write("={");
        if (StringUtils.isNotBlank((String)event)) {
            writer.write("\"uEvnt\":\"").write(event).write("\",");
        }
        if (StringUtils.isNotBlank((String)function)) {
            writer.write("\"uFunc\":").write(function).write(",");
        }
        writer.write("\"uId\":\"").write(id).write("\"");
        if (this.getRequestContextUtil().isRemoteViewer()) {
            writer.write(",\"uViewer\":\"").write(this.getRequestContextUtil().getRemoteViewer()).write("\"");
        }
        if (pageAction != null) {
            String confirm;
            String actionPath;
            String[] valueList;
            if ("ux.disable".equals(function)) {
                writer.write(",\"uFire\":true");
            }
            if (pageAction.isUplAttribute("validations") && pageAction.getUplAttribute(Object.class, "validations") != null) {
                writer.write(",\"uValidateAct\":\"").write(pageAction.getId()).write("\"");
            }
            if (pageAction.isUplAttribute("command")) {
                String cmd = (String)pageAction.getUplAttribute(String.class, "command");
                if (cmd != null) {
                    writer.write(",\"uCmdURL\":\"");
                    writer.writeCommandURL(pathId);
                    writer.write(Character.valueOf('\"'));
                    writer.write(",\"uTrgCmd\":\"").write(cmd).write("\"");
                    if (!StringUtils.isBlank((String)cmdTag)) {
                        writer.write(",\"uCmdTag\":\"").write(cmdTag).write("\"");
                    }
                }
                String targetCmdPgNm = null;
                String commandTarget = (String)pageAction.getUplAttribute(String.class, "target");
                if (commandTarget != null) {
                    targetCmdPgNm = "PARENT".equals(commandTarget) ? pageManager.getPageName(pageAction.getParentLongName().substring(0, pageAction.getParentLongName().lastIndexOf(46))) : pageManager.getPageName(commandTarget);
                }
                if (targetCmdPgNm == null) {
                    targetCmdPgNm = pageManager.getPageName(pageAction.getParentLongName());
                }
                writer.write(",\"uTrgPnl\":\"").write(targetCmdPgNm).write("\"");
                UplElementReferences uer = (UplElementReferences)pageAction.getUplAttribute(UplElementReferences.class, "refresh");
                if (uer != null) {
                    writer.write(",\"uRefreshPnls\":").writeJsonArray(pageManager.getPageNames(uer.getLongNames()));
                } else {
                    String targetRefreshPgNm = this.getRequestContextUtil().getDynamicPanelParentPageName();
                    if (targetRefreshPgNm == null) {
                        targetRefreshPgNm = pageManager.getPageName(pageAction.getParentLongName());
                    }
                    writer.write(",\"uRefreshPnls\":[\"").write(targetRefreshPgNm).write("\"]");
                }
            }
            if (((Boolean)pageAction.getUplAttribute(Boolean.TYPE, "pushSrc")).booleanValue()) {
                writer.write(",\"uPushSrc\":true");
            }
            List<String> componentList = pageManager.getExpandedReferences(pageAction.getId());
            writer.write(",\"uRef\":").writeJsonArray(componentList);
            List<String> valueComponentList = pageManager.getValueReferences(pageAction.getId());
            writer.write(",\"uVRef\":").writeJsonArray(valueComponentList);
            if (pageAction.isUplAttribute("valueList") && (valueList = (String[])pageAction.getUplAttribute(String[].class, "valueList")) != null) {
                writer.write(",\"uVal\":").writeJsonArray(valueList);
            }
            if (pageAction.isUplAttribute("path") && (actionPath = (String)pageAction.getUplAttribute(String.class, "path")) != null) {
                if (TokenUtils.isNameTag((String)actionPath) || TokenUtils.isPathTag((String)actionPath)) {
                    actionPath = pathId + TokenUtils.extractTokenValue((String)actionPath);
                } else if (TokenUtils.isRequestPathActionTag((String)actionPath)) {
                    actionPath = pathId + this.getRequestAttribute(TokenUtils.extractTokenValue((String)actionPath));
                } else if (TokenUtils.isQuickReferenceTag((String)actionPath)) {
                    actionPath = (String)((ValueStore)this.getRequestContext().getQuickReference()).retrieve(TokenUtils.extractTokenValue((String)actionPath));
                }
                writer.write(",\"uURL\":\"");
                writer.writeContextURL(actionPath, new String[0]);
                writer.write(Character.valueOf('\"'));
            }
            if ("ux.download".equals(function)) {
                writer.write(",\"uURL\":\"");
                writer.writeContextResourceURL("/resource/downloadpath", MimeType.APPLICATION_OCTETSTREAM.template(), (String)pageAction.getUplAttribute(String.class, "resource"), null, true, false);
                writer.write(Character.valueOf('\"'));
            }
            if (pageAction.isUplAttribute("debounce")) {
                writer.write(",\"uIsDebounce\":");
                writer.write(pageAction.getUplAttribute(Boolean.TYPE, "debounce"));
            }
            if (pageAction.isUplAttribute("confirm") && StringUtils.isNotBlank((String)(confirm = (String)pageAction.getUplAttribute(String.class, "confirm")))) {
                writer.write(",\"uConf\":");
                this.writeStringParameter(writer, confirm);
                writer.write(",\"uIconIndex\":");
                writer.write(pageAction.getUplAttribute(Integer.TYPE, "iconIndex"));
                writer.write(",\"uConfURL\":\"");
                writer.writeContextURL(pathId, "/confirm");
                writer.write(Character.valueOf('\"'));
            }
        } else if (refPageNames != null) {
            writer.write(",\"uRef\":").writeJsonArray(refPageNames);
        } else if (StringUtils.isNotBlank((String)refObject)) {
            writer.write(",\"uRef\":").write(refObject);
        } else if (path != null) {
            if (TokenUtils.isNameTag((String)path) || TokenUtils.isPathTag((String)path)) {
                path = pathId + TokenUtils.extractTokenValue((String)path);
            } else if (TokenUtils.isRequestPathActionTag((String)path)) {
                path = pathId + this.getRequestAttribute(TokenUtils.extractTokenValue((String)path));
            }
            writer.write(",\"uURL\":\"");
            writer.writeContextURL(path, new String[0]);
            writer.write(Character.valueOf('\"'));
        }
        writer.write("};");
        return eventParams;
    }

    protected PageRequestContextUtil getRequestContextUtil() throws UnifyException {
        return (PageRequestContextUtil)this.getComponent("application-pagerequestcontextutil");
    }

    protected PageManager getPageManager() throws UnifyException {
        return this.pageManager;
    }

    protected void writeStringParameter(ResponseWriter writer, String string) {
        if (string != null && !string.trim().isEmpty()) {
            writer.write("\"").write(string).write("\"");
        } else {
            writer.write("null");
        }
    }

    private void writeRefObjectEventHandlerJS(ResponseWriter writer, String pageName, String cmdTag, String eventType, String action, String refObject) throws UnifyException {
        String event = WriterUtils.getEventJS(eventType.toLowerCase());
        String function = WriterUtils.getActionJSFunction(action.toLowerCase());
        String eventParams = this.writeActionParamsJS(writer, event, function, pageName, cmdTag, null, null, refObject, null);
        writer.write("ux.setOnEvent(").write(eventParams).write(");");
    }
}

