/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.ui.widget.Panel;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.writer.AbstractContainerWriter;
import com.tcdng.unify.web.ui.widget.writer.PanelWriter;

public abstract class AbstractPanelWriter
extends AbstractContainerWriter
implements PanelWriter {
    @Override
    public void writeInnerStructureAndContent(ResponseWriter writer, Panel panel) throws UnifyException {
        panel.cascadeValueStore();
        this.doWriteInnerStructureAndContent(writer, panel);
    }

    @Override
    protected void doWriteStructureAndContent(ResponseWriter writer, Widget widget) throws UnifyException {
        Panel panel = (Panel)widget;
        writer.write("<div");
        this.writePanelTagAttributes(writer, panel);
        writer.write(">");
        this.writeInnerStructureAndContent(writer, panel);
        writer.write("</div>");
    }

    @Override
    protected void doWriteBehavior(ResponseWriter writer, Widget widget) throws UnifyException {
        int refreshEvery;
        super.doWriteBehavior(writer, widget);
        Panel panel = (Panel)widget;
        if (panel.isAllowRefresh() && (refreshEvery = panel.getRefreshEvery()) > 0) {
            String path = panel.getRefreshPath();
            writer.write("ux.setDelayedPanelPost({");
            writer.write("\"pId\":\"").write(panel.getId()).write(Character.valueOf('\"'));
            writer.write(",\"pURL\":\"");
            if (path == null) {
                writer.writeCommandURL();
            } else {
                writer.writeContextURL(path, new String[0]);
            }
            writer.write(Character.valueOf('\"'));
            writer.write(",\"pOnUserAct\":").write(panel.isRefreshOnUserAct());
            writer.write(",\"pPeriodMilliSec\":").write(refreshEvery);
            writer.write("});");
        }
    }

    protected void writePanelTagAttributes(ResponseWriter writer, Panel panel) throws UnifyException {
        String backImageSrc = panel.getBackImageSrc();
        if (StringUtils.isNotBlank((String)backImageSrc)) {
            this.writeTagId(writer, panel);
            this.writeTagStyleClassWithLeadingExtraStyleClasses(writer, panel, "ui-panel");
            writer.write(" style=\"background: url('");
            writer.writeFileImageContextURL(backImageSrc);
            writer.write("') no-repeat;background-size:cover;");
            String style = panel.getStyle();
            if (style != null) {
                writer.write(style);
            }
            writer.write("\"");
        } else {
            this.writeTagAttributes(writer, panel);
        }
    }

    protected void doWriteInnerStructureAndContent(ResponseWriter writer, Panel panel) throws UnifyException {
        String legend = panel.getLegend();
        boolean isLegend = StringUtils.isNotBlank((String)legend);
        if (isLegend) {
            writer.write("<fieldset><legend>");
            this.writeAttributeWithEscape(writer, panel, "legend");
            writer.write("</legend>");
        }
        if (!this.getRequestContextUtil().isPanelSwitched(panel)) {
            panel.switchState();
        }
        this.writeLayoutContent(writer, panel);
        if (isLegend) {
            writer.write("</fieldset>");
        }
    }
}

