/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.TargetControl;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.writer.AbstractControlWriter;

public abstract class AbstractTargetControlWriter
extends AbstractControlWriter {
    @Override
    protected void doWriteStructureAndContent(ResponseWriter writer, Widget widget) throws UnifyException {
        TargetControl targetControl = (TargetControl)widget;
        writer.write("<input type=\"hidden\"");
        this.writeTagId(writer, targetControl.getTargetId());
        String value = null;
        if (!targetControl.isAlwaysValueIndex() && (value = targetControl.getStaticBindingValue()) == null) {
            value = targetControl.getStringValue();
        }
        if (value != null) {
            writer.write(" value=\"").writeWithHtmlEscape(value).write("\"");
        } else {
            int index = targetControl.getValueIndex();
            if (index >= 0) {
                String indexPrefix = targetControl.getValueMarker();
                if (indexPrefix != null) {
                    writer.write(" value=\"").write(indexPrefix).write(Character.valueOf(':')).write(index).write("\"");
                } else {
                    writer.write(" value=\"").write(index).write("\"");
                }
            }
        }
        writer.write("/>");
        this.doWriteTargetControl(writer, targetControl);
        if (targetControl.isDebounce()) {
            this.getRequestContextUtil().registerWidgetDebounce(targetControl.getId());
        }
    }

    protected abstract void doWriteTargetControl(ResponseWriter var1, TargetControl var2) throws UnifyException;
}

