/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer;

import com.tcdng.unify.core.RequestContext;
import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.UserToken;
import com.tcdng.unify.core.annotation.Configurable;
import com.tcdng.unify.core.util.ColorUtils;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.font.FontSymbolManager;
import com.tcdng.unify.web.ui.widget.EventHandler;
import com.tcdng.unify.web.ui.widget.PageManager;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.writer.AbstractDhtmlWriter;
import com.tcdng.unify.web.ui.widget.writer.WidgetWriter;
import java.util.List;

public abstract class AbstractWidgetWriter
extends AbstractDhtmlWriter
implements WidgetWriter {
    @Configurable
    private FontSymbolManager fontSymbolManager;

    public final void setFontSymbolManager(FontSymbolManager fontSymbolManager) {
        this.fontSymbolManager = fontSymbolManager;
    }

    @Override
    public void writeStructureAndContent(ResponseWriter writer, Widget widget) throws UnifyException {
        widget.updateInternalState();
        this.doWriteStructureAndContent(writer, widget);
        widget.addPageAliases();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeStructureAndContent(ResponseWriter writer, Widget widget, String id) throws UnifyException {
        String origId = widget.getId();
        try {
            widget.setId(id);
            widget.updateInternalState();
            this.doWriteStructureAndContent(writer, widget);
            widget.addPageAliases();
        }
        finally {
            widget.setId(origId);
        }
    }

    @Override
    public void writeSectionStructureAndContent(ResponseWriter writer, Widget widget, String sectionId) throws UnifyException {
        this.doWriteSectionStructureAndContent(writer, widget, sectionId);
    }

    @Override
    public void writeBehavior(ResponseWriter writer, Widget widget) throws UnifyException {
        this.doWriteBehavior(writer, widget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBehavior(ResponseWriter writer, Widget widget, String id) throws UnifyException {
        String origId = widget.getId();
        try {
            widget.setId(id);
            this.doWriteBehavior(writer, widget);
        }
        finally {
            widget.setId(origId);
        }
    }

    @Override
    public void writeSectionBehavior(ResponseWriter writer, Widget widget, String sectionId) throws UnifyException {
        this.doWriteSectionBehavior(writer, widget, sectionId);
    }

    protected abstract void doWriteStructureAndContent(ResponseWriter var1, Widget var2) throws UnifyException;

    protected final boolean isWithFontSymbolManager() {
        return this.fontSymbolManager != null;
    }

    protected List<String> getFontResources() throws UnifyException {
        return this.fontSymbolManager.getFontResources();
    }

    protected String resolveSymbolUnicode(String symbolName) throws UnifyException {
        return this.fontSymbolManager.resolveSymbolUnicode(symbolName);
    }

    protected String resolveSymbolHtmlHexCode(String symbolName) throws UnifyException {
        return this.fontSymbolManager.resolveSymbolHtmlHexCode(symbolName);
    }

    protected void doWriteSectionStructureAndContent(ResponseWriter writer, Widget widget, String sectionId) throws UnifyException {
    }

    protected void doWriteBehavior(ResponseWriter writer, Widget widget) throws UnifyException {
        EventHandler[] eventHandlers;
        if (!widget.isContainerDisabled() && (eventHandlers = (EventHandler[])widget.getUplAttribute(EventHandler[].class, "eventHandler")) != null) {
            String id = widget.getId();
            if (widget.isBindEventsToFacade()) {
                id = widget.getFacadeId();
            }
            this.getRequestContext().setQuickReference((Object)widget.getValueStore());
            for (EventHandler eventHandler : eventHandlers) {
                writer.writeBehavior(eventHandler, id, widget.getBinding());
            }
        }
    }

    protected void doWriteSectionBehavior(ResponseWriter writer, Widget widget, String sectionId) throws UnifyException {
    }

    @Override
    protected PageManager getPageManager() throws UnifyException {
        return (PageManager)this.getComponent("application-pagemanager");
    }

    protected String getCommandURL() throws UnifyException {
        return this.getContextURL(this.getRequestContextUtil().getResponsePathParts().getControllerPathId(), "/command");
    }

    protected String getContextURL(String path, String ... pathElement) throws UnifyException {
        StringBuilder sb = new StringBuilder();
        RequestContext requestContext = this.getRequestContext();
        if (this.getRequestContextUtil().isRemoteViewer()) {
            sb.append(this.getSessionContext().getUriBase());
        }
        sb.append(requestContext.getContextPath());
        if (requestContext.isWithTenantPath()) {
            sb.append(requestContext.getTenantPath());
        }
        sb.append(requestContext.getRequestPath());
        sb.append(path);
        for (String element : pathElement) {
            sb.append(element);
        }
        return sb.toString();
    }

    protected String getUserColorStyleClass(String classBase) throws UnifyException {
        UserToken userToken = this.getUserToken();
        if (userToken != null && StringUtils.isNotBlank((String)userToken.getColorScheme())) {
            return classBase + userToken.getColorScheme();
        }
        String configColorScheme = ColorUtils.getConformingColorSchemeCode((String)((String)this.getContainerSetting(String.class, "application.colorscheme")));
        if (!StringUtils.isBlank((String)configColorScheme)) {
            return classBase + configColorScheme;
        }
        return classBase;
    }
}

