/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.container;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Configurable;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.constant.MimeType;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.ControllerPathParts;
import com.tcdng.unify.web.ui.PagePathInfoRepository;
import com.tcdng.unify.web.ui.widget.DocumentLayout;
import com.tcdng.unify.web.ui.widget.Panel;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.container.BasicDocument;
import com.tcdng.unify.web.ui.widget.container.BasicDocumentResources;
import com.tcdng.unify.web.ui.widget.writer.AbstractPageWriter;

@Writes(value=BasicDocument.class)
@Component(value="document-writer")
public class DocumentWriter
extends AbstractPageWriter {
    @Configurable
    private PagePathInfoRepository pathInfoRepository;
    @Configurable
    private BasicDocumentResources resources;

    public void setPathInfoRepository(PagePathInfoRepository pathInfoRepository) {
        this.pathInfoRepository = pathInfoRepository;
    }

    public void setResources(BasicDocumentResources resources) {
        this.resources = resources;
    }

    @Override
    protected void doWriteStructureAndContent(ResponseWriter writer, Widget widget) throws UnifyException {
        BasicDocument document = (BasicDocument)widget;
        writer.write("<!DOCTYPE html>");
        writer.write("<html ");
        this.writeTagAttributes(writer, document);
        writer.write(">");
        writer.write("<head>");
        writer.write("<title>");
        String title = (String)document.getUplAttribute(String.class, "caption");
        if (StringUtils.isNotBlank((String)title)) {
            writer.write(title);
        } else {
            writer.write(this.getUnifyComponentContext().getInstanceName());
        }
        writer.write("</title>");
        if (document.getMeta() != null) {
            for (String oneMeta : document.getMeta()) {
                writer.write("<meta ");
                writer.write(oneMeta);
                writer.write(" >");
            }
        }
        writer.write("<link rel=\"shortcut icon\" href=\"");
        writer.writeFileImageContextURL((String)document.getUplAttribute(String.class, "favicon"));
        writer.write("\">");
        this.writeStyleSheet(writer, "$t{css/unify-web.css}");
        for (String styleSheet : this.getPageManager().getDocumentStyleSheets()) {
            this.writeStyleSheet(writer, styleSheet);
        }
        String[] styleSheets = (String[])document.getUplAttribute(String[].class, "styleSheet");
        if (styleSheets != null) {
            for (String styleSheet : styleSheets) {
                this.writeStyleSheet(writer, styleSheet);
            }
        }
        this.writeResourcesStyleSheet(writer);
        this.writeEmbeddedStyle(writer, document);
        this.writeJavascript(writer, "web/js/unify-web.js");
        for (String script : this.getPageManager().getDocumentsScripts()) {
            this.writeJavascript(writer, script);
        }
        String[] scripts = (String[])document.getUplAttribute(String[].class, "script");
        if (scripts != null) {
            for (String script : scripts) {
                this.writeJavascript(writer, script);
            }
        }
        this.writeResourcesScript(writer);
        writer.write("</head>");
        writer.write("<body class=\"dBody\"");
        String style = document.getStyle();
        String backImageSrc = document.getBackImageSrc();
        if (StringUtils.isNotBlank((String)backImageSrc)) {
            writer.write(" style=\"background: url('");
            writer.writeFileImageContextURL(backImageSrc);
            writer.write("') no-repeat;background-size:cover;");
            if (style != null) {
                writer.write(style);
            }
            writer.write("\"");
        } else if (style != null) {
            writer.write(" style=\"").write(style).write("\"");
        }
        writer.write(">");
        writer.write("<div id=\"").write(document.getPopupBaseId()).write("\" class=\"dcpopbase\">");
        writer.write("<div id=\"").write(document.getPopupWinId()).write("\" class=\"dcpop\"></div>");
        writer.write("<div id=\"").write(document.getPopupSysId()).write("\" class=\"dcsysinfo\"></div>");
        writer.write("</div>");
        DocumentLayout documentLayout = (DocumentLayout)document.getUplAttribute(DocumentLayout.class, "layout");
        writer.writeStructureAndContent(documentLayout, document);
        writer.write("</body></html>");
    }

    @Override
    protected void doWriteBehavior(ResponseWriter writer, Widget widget) throws UnifyException {
        BasicDocument document = (BasicDocument)widget;
        writer.write("<script>");
        ControllerPathParts controllerPathParts = this.pathInfoRepository.getControllerPathParts(document);
        writer.write("ux.setupDocument(\"").write(controllerPathParts.getControllerName()).write("\", \"").write(document.getPopupBaseId()).write("\", \"").write(document.getPopupWinId()).write("\", \"").write(document.getPopupSysId()).write("\", \"").write(this.getSessionContext().getId()).write("\");");
        DocumentLayout documentLayout = (DocumentLayout)document.getUplAttribute(DocumentLayout.class, "layout");
        writer.writeBehavior(documentLayout, document);
        super.doWriteBehavior(writer, document);
        this.writeBehaviour(writer, document.getHeaderPanel());
        this.writeBehaviour(writer, document.getMenuPanel());
        this.writeBehaviour(writer, document.getContentPanel());
        this.writeBehaviour(writer, document.getFooterPanel());
        writer.write("var aliasPrms = {");
        writer.write("\"pageNameAliases\":");
        writer.writeJsonPageNameAliasesArray();
        writer.write("}; ux.setPageNameAliases(aliasPrms);");
        if (this.getRequestContextUtil().isRegisteredDebounceWidgets()) {
            writer.write("var debounceList = ").writeJsonArray(this.getRequestContextUtil().getAndClearRegisteredDebounceWidgetIds()).write(";");
            writer.write("ux.registerDebounce(debounceList);");
        }
        writer.write("ux.cascadeStretch();");
        this.getRequestContextUtil().considerDefaultFocusOnWidget();
        if (this.getRequestContextUtil().isFocusOnWidgetOrDefault()) {
            writer.write("ux.setFocus(\"").write(this.getRequestContextUtil().getFocusOnWidgetIdOrDefault()).write("\");");
            this.getRequestContextUtil().clearFocusOnWidget();
        }
        writer.write("</script>");
    }

    @Override
    protected void doWriteInnerStructureAndContent(ResponseWriter writer, Panel panel) throws UnifyException {
    }

    private void writeEmbeddedStyle(ResponseWriter writer, BasicDocument document) throws UnifyException {
        writer.write("<style>");
        this.writeImageBeforeCss(writer, " .g_cba", "$t{images/checked.png}");
        this.writeImageBeforeCss(writer, " .g_cbb", "$t{images/unchecked.png}");
        this.writeImageBeforeCss(writer, " .g_cbc", "$t{images/checked_gray.png}");
        this.writeImageBeforeCss(writer, " .g_cbd", "$t{images/unchecked_gray.png}");
        if (this.isWithFontSymbolManager()) {
            StringBuilder fsb = new StringBuilder();
            int i = 0;
            fsb.append(".g_fsm {font-family: ").append((String)document.getUplAttribute(String.class, "fontFamily"));
            for (String fontResource : this.getFontResources()) {
                fsb.append(", 'FontSymbolMngr").append(i).append('\'');
                writer.write("@font-face {font-family: 'FontSymbolMngr").write(i).write("'; src: url(");
                writer.writeContextResourceURL("/resource/file", MimeType.APPLICATION_OCTETSTREAM.template(), fontResource);
                writer.write(");} ");
                ++i;
            }
            fsb.append(";}");
            writer.write(fsb);
        }
        writer.write("</style>");
    }

    private void writeImageBeforeCss(ResponseWriter writer, String className, String imgSrc) throws UnifyException {
        writer.write(className).write(" {vertical-align:middle;display: inline-block !important;} ").write(className).write(":before {content: \"\";vertical-align:middle;display: inline-block;width: 100%;height: 100%;background: url(");
        writer.writeFileImageContextURL(imgSrc);
        writer.write(")no-repeat center/100% 100%; }");
    }

    private void writeResourcesStyleSheet(ResponseWriter writer) throws UnifyException {
        if (this.resources != null) {
            for (String sheetLink : this.resources.getStyleSheetResourceLinks()) {
                writer.write("<link href=\"");
                writer.write(sheetLink);
                writer.write("\" rel=\"stylesheet\" type=\"text/css\" media=\"screen\">");
            }
        }
    }

    private void writeResourcesScript(ResponseWriter writer) throws UnifyException {
        if (this.resources != null) {
            for (String scriptLink : this.resources.getScriptResourceLinks()) {
                writer.write("<script src=\"");
                writer.write(scriptLink);
                writer.write("\"></script>");
            }
        }
    }

    private void writeStyleSheet(ResponseWriter writer, String styleSheet) throws UnifyException {
        writer.write("<link href=\"");
        writer.writeContextResourceURL("/resource/file", MimeType.TEXT_CSS.template(), styleSheet);
        writer.write("\" rel=\"stylesheet\" type=\"text/css\" media=\"screen\">");
    }

    private void writeJavascript(ResponseWriter writer, String script) throws UnifyException {
        writer.write("<script src=\"");
        writer.writeContextResourceURL("/resource/file", MimeType.TEXT_JAVASCRIPT.template(), script);
        writer.write("\"></script>");
    }

    private void writeBehaviour(ResponseWriter writer, Panel panel) throws UnifyException {
        if (panel != null) {
            writer.writeBehavior(panel);
        }
    }
}

