/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.container;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.ui.Menu;
import com.tcdng.unify.core.ui.MenuItem;
import com.tcdng.unify.core.ui.MenuItemSet;
import com.tcdng.unify.core.ui.MenuSet;
import com.tcdng.unify.core.util.DataUtils;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.core.util.json.JsonWriter;
import com.tcdng.unify.web.ui.widget.Container;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.panel.AbstractFlyoutMenu;
import com.tcdng.unify.web.ui.widget.panel.FlyoutMenu;
import com.tcdng.unify.web.ui.widget.writer.AbstractPanelWriter;
import com.tcdng.unify.web.util.HtmlUtils;
import java.util.ArrayList;
import java.util.List;

@Writes(value=FlyoutMenu.class)
@Component(value="flyoutmenu-writer")
public class FlyoutMenuWriter
extends AbstractPanelWriter {
    private static final int DYNAMIC_CHILD_OFFSET = 10;
    private static final String MENU_CATEGORY_CLASSBASE = "opcat";
    private static final String MENUITEM_CATEGORY_CLASSBASE = "mcat";
    private static final String ORIGINAL_MENU_PATHID = "ORIGINAL_MENU_PATHID";

    @Override
    protected void doWriteBehavior(ResponseWriter writer, Widget widget) throws UnifyException {
        FlyoutMenu flyoutMenu = (FlyoutMenu)widget;
        ArrayList<String> menuWinIdList = new ArrayList<String>();
        for (String id : flyoutMenu.getActiveMenuItemIds()) {
            MenuItem menuItem = flyoutMenu.getActiveMenuItem(id);
            if (!menuItem.isMain()) continue;
            String popupId = "pop_" + id;
            String popupContentId = "popc_" + id;
            String menuWinId = "win_" + id;
            String json = new JsonWriter().beginObject().write("menuWinId", menuWinId).write("windowId", flyoutMenu.getSliderWinId()).write("popupId", popupId).write("popupContentId", popupContentId).write("vertical", flyoutMenu.isVertical()).endObject().toString();
            this.writeOpenPopupJS(writer, "onmouseover", id, widget.getBinding(), null, popupId, 500L, "repositionmenupopup", json, null, null);
            menuWinIdList.add(menuWinId);
        }
        writer.beginFunction("ux.rigFlyoutMenu");
        writer.writeParam("pId", flyoutMenu.getId());
        writer.writeParam("pContId", flyoutMenu.getContainerId());
        String originalPathId = (String)this.getSessionAttribute(ORIGINAL_MENU_PATHID);
        if (!StringUtils.isBlank((String)originalPathId)) {
            writer.writeCommandURLParam("pCmdURL", originalPathId);
        } else {
            originalPathId = this.getRequestContextUtil().getResponsePathParts().getControllerPathId();
            this.setSessionAttribute(ORIGINAL_MENU_PATHID, originalPathId);
            writer.writeCommandURLParam("pCmdURL");
        }
        writer.writeParam("pMenuWinId", (String[])DataUtils.toArray(String.class, menuWinIdList));
        writer.writeParam("pNavId", flyoutMenu.getNavId());
        writer.writeParam("pVertical", flyoutMenu.isVertical());
        MenuSet menuSet = (MenuSet)this.getApplicationAttribute("APPLICATION_MENUSET");
        if (menuSet.isShowSelect()) {
            writer.writeParam("pSelId", flyoutMenu.getSelectId());
            writer.writeParam("pCurSelId", flyoutMenu.getCurrentSelCtrl().getId());
        }
        JsonWriter itemsJson = new JsonWriter();
        itemsJson.beginArray();
        for (String id : flyoutMenu.getActiveMenuItemIds()) {
            MenuItem menuItem = flyoutMenu.getActiveMenuItem(id);
            if (!this.getViewDirective(menuItem.getPrivilege()).isVisible() || StringUtils.isBlank((String)menuItem.getActionPath())) continue;
            itemsJson.beginObject();
            itemsJson.write("id", id);
            itemsJson.write("main", menuItem.isMain());
            itemsJson.write("actionPath", this.getContextURL(menuItem.getActionPath(), new String[0]));
            if (!StringUtils.isBlank((String)menuItem.getOriginPath())) {
                itemsJson.write("originPath", menuItem.getOriginPath());
            }
            itemsJson.endObject();
        }
        itemsJson.endArray();
        writer.writeParam("pMenuItems", itemsJson);
        writer.endFunction();
    }

    @Override
    protected void writeLayoutContent(ResponseWriter writer, Container container) throws UnifyException {
        AbstractFlyoutMenu flyoutMenu = (AbstractFlyoutMenu)container;
        flyoutMenu.clear();
        writer.write("<div style=\"display:table;width:100%;height:100%;table-layout:fixed;\">");
        writer.write("<div style=\"display:table-row;\">");
        if (flyoutMenu.isVertical()) {
            writer.write("<div style=\"display:table-cell; height:100%;\">");
        } else {
            writer.write("<div style=\"display:table-cell;\">");
        }
        writer.write("<div id=\"").write(flyoutMenu.getSliderWinId()).write("\"");
        writer.write(" style=\"display:inline-block;width:100%;height:100%;\">");
        writer.write("<ul id=\"").write(flyoutMenu.getNavId()).write("\" class=\"nav\">");
        StringBuilder psb = new StringBuilder();
        MenuSet menuSet = (MenuSet)this.getApplicationAttribute("APPLICATION_MENUSET");
        boolean isShowMenu = true;
        if (menuSet.isShowSelect()) {
            ArrayList<Integer> visibleIndexList = new ArrayList<Integer>();
            for (int i = 0; i < menuSet.size(); ++i) {
                if (!this.getViewDirective(menuSet.getMenu(i).getPrivilege()).isVisible()) continue;
                visibleIndexList.add(i);
            }
            if (!visibleIndexList.isEmpty() && !visibleIndexList.contains(flyoutMenu.getCurrentSel())) {
                flyoutMenu.setCurrentSel((Integer)visibleIndexList.get(0));
            }
            writer.write("<li><select id=\"").write(flyoutMenu.getSelectId()).write("\" class=\"mselect\">");
            for (Integer i : visibleIndexList) {
                writer.write("<option value=\"").write(i).write("\"");
                if (i.intValue() == flyoutMenu.getCurrentSel()) {
                    writer.write(" selected");
                }
                writer.write(">");
                writer.writeWithHtmlEscape(menuSet.getMenu(i.intValue()).getCaption());
                writer.write("</option>");
            }
            writer.write("</select></li>");
            boolean bl = isShowMenu = !visibleIndexList.isEmpty();
        }
        if (isShowMenu && !menuSet.isEmpty()) {
            int childIndex = 10;
            Menu menu = menuSet.getMenu(flyoutMenu.getCurrentSel());
            String opcat = MENU_CATEGORY_CLASSBASE;
            String mcat = MENUITEM_CATEGORY_CLASSBASE;
            if (StringUtils.isNotBlank((String)menu.getColorScheme())) {
                String scheme = menu.getColorScheme();
                opcat = opcat + scheme;
                mcat = mcat + scheme;
            } else {
                opcat = this.getUserColorStyleClass(opcat);
                mcat = this.getUserColorStyleClass(mcat);
            }
            for (MenuItemSet menuItemSet : menu.getMenuItemSetList()) {
                if (!this.getViewDirective(menuItemSet.getPrivilege()).isVisible()) continue;
                String menuId = flyoutMenu.getNamingIndexedId(childIndex++);
                flyoutMenu.addActiveMenuItem(menuId, (MenuItem)menuItemSet);
                writer.write("<li id=\"").write("win_" + menuId).write("\">");
                writer.write("<a class=\"option ").write(opcat).write("\" id=\"").write(menuId).write("\">");
                writer.writeWithHtmlEscape(this.resolveSessionMessage(menuItemSet.getCaption(), new Object[0]));
                writer.write("</a>");
                writer.write("</li>");
                List menuItemList = menuItemSet.getMenuItemList();
                if (menuItemList.isEmpty()) continue;
                psb.append("<div");
                this.writeTagId(psb, "pop_" + menuId);
                this.writeTagStyleClass(psb, "flyoutmenu-popup");
                psb.append(">");
                psb.append("<ul id=\"").append("popc_" + menuId).append("\">");
                for (MenuItem menuItem : menuItemList) {
                    if (!this.getViewDirective(menuItem.getPrivilege()).isVisible()) continue;
                    String menuItemId = flyoutMenu.getNamingIndexedId(childIndex++);
                    flyoutMenu.addActiveMenuItem(menuItemId, menuItem);
                    if (menuItem.isHidden()) continue;
                    psb.append("<li><a class=\"mitem ").append(mcat).append("\" id=\"").append(menuItemId).append("\">");
                    HtmlUtils.writeStringWithHtmlEscape((StringBuilder)psb, (String)this.resolveSessionMessage(menuItem.getCaption(), new Object[0]));
                    psb.append("</a></li>");
                }
                psb.append("</ul>");
                psb.append("</div>");
            }
        }
        writer.write("</ul>");
        writer.write("</div>");
        writer.write("</div>");
        writer.write("</div>");
        writer.write("</div>");
        writer.writeStructureAndContent(flyoutMenu.getCurrentSelCtrl());
        writer.write(psb.toString());
    }
}

