/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.container;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.ViewDirective;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.data.ValueStore;
import com.tcdng.unify.web.ui.PageRequestContextUtil;
import com.tcdng.unify.web.ui.widget.Container;
import com.tcdng.unify.web.ui.widget.Control;
import com.tcdng.unify.web.ui.widget.PushType;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Section;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.container.Form;
import com.tcdng.unify.web.ui.widget.writer.AbstractContainerWriter;
import java.util.List;

@Writes(value=Form.class)
@Component(value="form-writer")
public class FormWriter
extends AbstractContainerWriter {
    @Override
    protected void writeLayoutContent(ResponseWriter writer, Container container) throws UnifyException {
        Form form = (Form)container;
        form.cascadeValueStore();
        String groupId = null;
        if (form.isContainerEditable()) {
            groupId = form.getDataGroupId();
        }
        boolean isFormDisabled = form.isDisabled();
        boolean isFormEditable = form.isEditable();
        for (Form.FormSection formSection : form.getSections()) {
            ViewDirective viewDirective = this.getViewDirective(formSection.getPrivilege());
            if (!viewDirective.isVisible() || !formSection.isVisible()) continue;
            form.setDisabled(isFormDisabled || viewDirective.isDisabled() || formSection.isDisabled());
            form.setEditable(isFormEditable && viewDirective.isEditable() && formSection.isEditable());
            if (formSection.isBinding()) {
                if (formSection.isBindingValueList()) {
                    for (ValueStore valueStore : formSection.getValueStoreList()) {
                        this.writeSectionStructureAndContent(writer, form, formSection, valueStore, groupId);
                    }
                } else {
                    this.writeSectionStructureAndContent(writer, form, formSection, formSection.getValueStore(), null);
                }
            } else {
                this.writeSectionStructureAndContent(writer, form, formSection, null, null);
            }
            form.setEditable(isFormEditable);
            form.setDisabled(isFormDisabled);
        }
        if (form.isContainerEditable()) {
            this.writeHiddenPush(writer, form.getDataGroupId(), PushType.GROUP);
        }
    }

    @Override
    protected void writeContainedWidgetsBehavior(ResponseWriter writer, Container container) throws UnifyException {
        Form form = (Form)container;
        for (Form.FormSection formSection : form.getSections()) {
            ViewDirective viewDirective = this.getViewDirective(formSection.getPrivilege());
            if (!viewDirective.isVisible() || !formSection.isVisible()) continue;
            if (formSection.isBinding()) {
                if (formSection.isBindingValueList()) {
                    for (ValueStore valueStore : formSection.getValueStoreList()) {
                        this.writeSectionBehavior(writer, form, formSection, valueStore);
                    }
                    continue;
                }
                this.writeSectionBehavior(writer, form, formSection, formSection.getValueStore());
                continue;
            }
            this.writeSectionBehavior(writer, form, formSection, null);
        }
    }

    private void writeSectionBehavior(ResponseWriter writer, Form form, Form.FormSection formSection, ValueStore valueStore) throws UnifyException {
        for (String longName : formSection.getSection().getReferences()) {
            Widget widget = form.getWidgetByLongName(longName);
            if (!widget.isVisible() && !widget.isHidden()) continue;
            if (valueStore != null) {
                widget.setValueStore(valueStore);
            }
            writer.writeBehavior(widget);
        }
    }

    private void writeSectionStructureAndContent(ResponseWriter writer, Form form, Form.FormSection formSection, ValueStore valueStore, String groupId) throws UnifyException {
        Section section = formSection.getSection();
        if (section.isHidden()) {
            for (String longName : section.getReferences()) {
                Widget widget = form.getWidgetByLongName(longName);
                if (!widget.isHidden()) continue;
                if (valueStore != null) {
                    widget.setValueStore(valueStore);
                }
                if (groupId != null) {
                    widget.setGroupId(groupId);
                }
                writer.writeStructureAndContent(widget);
            }
            return;
        }
        String caption = section.getCaption();
        if (caption != null) {
            writer.write("<div><span class=\"secCaption\">");
            writer.writeWithHtmlEscape(caption);
            writer.write("</span></div>");
            writer.write("<div><table class=\"secCapBase\" style=\"width:100%;\"><tr>");
        } else {
            writer.write("<div><table class=\"sec\" style=\"width:100%;\"><tr>");
        }
        int columns = (Integer)form.getUplAttribute(Integer.TYPE, "columns");
        if (columns < 1) {
            columns = 1;
        }
        List<String> refList = section.getReferences();
        int itemCount = refList.size();
        int visibleCount = 0;
        for (int i = 0; i < itemCount; ++i) {
            if (!form.getWidgetByLongName(refList.get(i)).isVisible()) continue;
            ++visibleCount;
        }
        if (visibleCount > 0) {
            String captionSuffix = (String)form.getUplAttribute(String.class, "captionSuffix");
            int rows = visibleCount / columns;
            if (visibleCount % columns > 0) {
                ++rows;
            }
            boolean isWidgetCaptionless = section.isWidgetCaptionless();
            PageRequestContextUtil requestContextUtil = this.getRequestContextUtil();
            int columnWidth = 100 / columns;
            int i = 0;
            while (i < itemCount) {
                writer.write("<td class=\"secColumn\" style=\"width:");
                writer.write(columnWidth);
                writer.write("%\"><table style=\"width:100%;\">");
                int row = 0;
                while (row < rows && i < itemCount) {
                    Widget widget = form.getWidgetByLongName(refList.get(i));
                    if (valueStore != null) {
                        widget.setValueStore(valueStore);
                    }
                    if (groupId != null) {
                        widget.setGroupId(groupId);
                    }
                    if (widget.isVisible()) {
                        writer.write("<tr>");
                        caption = null;
                        if (widget.isLayoutCaption()) {
                            caption = (String)widget.getUplAttribute(String.class, "caption");
                        }
                        if (!isWidgetCaptionless) {
                            writer.write("<td class=\"secLabel\">");
                            if (caption != null) {
                                writer.writeWithHtmlEscape(caption);
                                if (captionSuffix != null) {
                                    writer.write(captionSuffix);
                                }
                            }
                            writer.write("</td>");
                            writer.write("<td class=\"secInputReq\">");
                            if (widget instanceof Control) {
                                if (((Control)widget).getRequired().isTrue()) {
                                    writer.write("<span>").write(form.getUplAttribute(String.class, "requiredSymbol")).write("</span>");
                                }
                                requestContextUtil.addOnSaveContentWidget(widget.getId());
                            }
                            writer.write("</td>");
                        }
                        writer.write("<td class=\"secInput\"><div>");
                        writer.writeStructureAndContent(widget);
                        writer.write("</div>");
                        if (widget instanceof Control) {
                            writer.write("<div><span id=\"").write(((Control)widget).getNotificationId()).write("\" class=\"secInputErr\"></span>");
                            writer.write("</div>");
                        }
                        writer.write("</td>");
                        writer.write("</tr>");
                        ++row;
                    } else if (widget.isHidden()) {
                        writer.writeStructureAndContent(widget);
                    }
                    ++i;
                }
                writer.write("</table></td>");
            }
        }
        writer.write("</tr></table></div>");
    }
}

