/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.container;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.data.ValueStore;
import com.tcdng.unify.core.ui.Tile;
import com.tcdng.unify.web.ui.widget.Container;
import com.tcdng.unify.web.ui.widget.Control;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.container.TileGroup;
import com.tcdng.unify.web.ui.widget.writer.AbstractContainerWriter;
import java.util.List;

@Writes(value=TileGroup.class)
@Component(value="tilegroup-writer")
public class TileGroupWriter
extends AbstractContainerWriter {
    @Override
    protected void doWriteBehavior(ResponseWriter writer, Widget widget) throws UnifyException {
        super.doWriteBehavior(writer, widget);
        TileGroup tileGroup = (TileGroup)widget;
        Control imageCtrl = tileGroup.getImageCtrl();
        for (ValueStore valueStore : tileGroup.getValueList()) {
            String actionPath = ((Tile)valueStore.getValueObject()).getActionPath();
            if (actionPath == null) continue;
            imageCtrl.setValueStore(valueStore);
            this.writePathEventHandlerJS(writer, imageCtrl.getId(), imageCtrl.getBinding(), "onclick", "post", actionPath);
        }
    }

    @Override
    protected void writeLayoutContent(ResponseWriter writer, Container container) throws UnifyException {
        TileGroup tileGroup = (TileGroup)container;
        List valueStoreList = tileGroup.getValueList();
        if (!valueStoreList.isEmpty()) {
            int columns = tileGroup.getColumns();
            if (columns <= 0) {
                columns = 1;
            }
            int childIndex = 0;
            int numCards = valueStoreList.size();
            int rows = numCards / columns;
            if (numCards % columns > 0) {
                ++rows;
            }
            Control imageCtrl = tileGroup.getImageCtrl();
            boolean isShowTitleSection = tileGroup.isShowTitleSection();
            writer.write("<div style=\"display:table;\"><div style=\"display:table-row;\">");
            for (int i = 0; i < columns; ++i) {
                writer.write("<div style=\"display:table-cell;\">");
                for (int j = 0; j < rows; ++j) {
                    int k = j * columns + i;
                    if (k >= numCards) continue;
                    ValueStore valueStore = (ValueStore)valueStoreList.get(childIndex++);
                    writer.write("<div class=\"tgtile\">");
                    imageCtrl.setValueStore(valueStore);
                    writer.writeStructureAndContent(imageCtrl);
                    if (isShowTitleSection) {
                        writer.write("<span id=\"").write(imageCtrl.getPrefixedId("spn_")).write("\">");
                        writer.writeWithHtmlEscape(((Tile)valueStore.getValueObject()).getCaption());
                        writer.write("</span>");
                    }
                    writer.write("</div>");
                }
                writer.write("</div>");
            }
            writer.write("</div></div>");
        }
    }
}

