/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.web.constant.ExtensionType;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.control.AbstractPopupTextField;
import com.tcdng.unify.web.ui.widget.writer.control.TextFieldWriter;

public abstract class AbstractPopupTextFieldWriter
extends TextFieldWriter {
    @Override
    protected void doWriteBehavior(ResponseWriter writer, Widget widget) throws UnifyException {
        AbstractPopupTextField popupTextField = (AbstractPopupTextField)widget;
        super.doWriteBehavior(writer, popupTextField);
        ExtensionType extensionType = popupTextField.getExtensionType();
        boolean popupEnabled = this.isPopupEnabled(popupTextField);
        if (popupEnabled && (popupTextField.isPopupAlways() || popupTextField.isContainerEditable() && !popupTextField.isContainerDisabled())) {
            String facId = popupTextField.getId();
            if (extensionType.isExtended()) {
                facId = popupTextField.getFacadeId();
            }
            String cmdTag = popupTextField.getBinding();
            if (!popupTextField.getExtensionType().isFacadeEdit()) {
                this.writeOpenPopupJS(writer, "onenter", facId, cmdTag, popupTextField.getBorderId(), popupTextField.getPopupId(), popupTextField.getDisplayTimeOut(), this.getOnShowAction(), this.getOnShowParam(popupTextField), this.getOnHideAction(), this.getOnHideParam(popupTextField));
                if (popupTextField.isOpenPopupOnFac()) {
                    this.writeOpenPopupJS(writer, "onclick", facId, cmdTag, popupTextField.getBorderId(), popupTextField.getPopupId(), popupTextField.getDisplayTimeOut(), this.getOnShowAction(), this.getOnShowParam(popupTextField), this.getOnHideAction(), this.getOnHideParam(popupTextField));
                }
                this.writeOpenPopupJS(writer, "onclick", popupTextField.getPopupButtonId(), cmdTag, popupTextField.getBorderId(), popupTextField.getPopupId(), popupTextField.getDisplayTimeOut(), this.getOnShowAction(), this.getOnShowParam(popupTextField), this.getOnHideAction(), this.getOnHideParam(popupTextField));
            }
        }
        this.doWritePopupTextFieldBehaviour(writer, popupTextField, popupEnabled);
    }

    @Override
    protected void writeTrailingAddOn(ResponseWriter writer, Widget widget) throws UnifyException {
        AbstractPopupTextField popupTextField = (AbstractPopupTextField)widget;
        writer.write("<button tabindex=\"-1\"");
        this.writeTagId(writer, popupTextField.getPopupButtonId());
        this.writeTagStyleClass(writer, "tpbutton g_fsm");
        if (popupTextField.isContainerDisabled()) {
            writer.write(" disabled");
        }
        writer.write(">");
        if (this.isWithFontSymbolManager()) {
            writer.write(this.resolveSymbolHtmlHexCode(popupTextField.getButtonSymbol()));
        } else {
            writer.write("<img src=\"");
            writer.writeFileImageContextURL(popupTextField.getButtonImageSrc());
            writer.write("\"/>");
        }
        writer.write("</button>");
    }

    @Override
    protected void writeBaseAddOn(ResponseWriter writer, Widget widget) throws UnifyException {
        AbstractPopupTextField popupTextField = (AbstractPopupTextField)widget;
        if (this.isPopupEnabled(popupTextField)) {
            writer.write("<div");
            this.writeTagId(writer, popupTextField.getPopupId());
            this.writeTagStyleClass(writer, "ui-text-popup-win");
            writer.write(">");
            this.writePopupContent(writer, popupTextField);
            writer.write("</div>");
        }
    }

    protected boolean isPopupEnabled(AbstractPopupTextField popupTextField) throws UnifyException {
        if (popupTextField.isPopupOnEditableOnly()) {
            return popupTextField.isContainerEditable() && !popupTextField.isContainerDisabled();
        }
        return true;
    }

    protected abstract void writePopupContent(ResponseWriter var1, AbstractPopupTextField var2) throws UnifyException;

    protected abstract void doWritePopupTextFieldBehaviour(ResponseWriter var1, AbstractPopupTextField var2, boolean var3) throws UnifyException;

    protected abstract String getOnShowAction() throws UnifyException;

    protected abstract String getOnShowParam(AbstractPopupTextField var1) throws UnifyException;

    protected abstract String getOnHideAction() throws UnifyException;

    protected abstract String getOnHideParam(AbstractPopupTextField var1) throws UnifyException;
}

