/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.constant.ColorScheme;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.control.Badge;
import com.tcdng.unify.web.ui.widget.data.BadgeInfo;
import com.tcdng.unify.web.ui.widget.writer.AbstractControlWriter;

@Writes(value=Badge.class)
@Component(value="badge-writer")
public class BadgeWriter
extends AbstractControlWriter {
    @Override
    protected void doWriteStructureAndContent(ResponseWriter writer, Widget widget) throws UnifyException {
        Badge badge = (Badge)widget;
        String caption = null;
        ColorScheme scheme = null;
        Object value = badge.getValue();
        if (value instanceof String) {
            caption = this.resolveSessionMessage((String)value, new Object[0]);
        } else if (value instanceof BadgeInfo) {
            BadgeInfo badgeInfo = (BadgeInfo)value;
            scheme = badgeInfo.getColorScheme();
            caption = this.resolveSessionMessage(badgeInfo.getCaption(), new Object[0]);
        }
        writer.write("<span");
        String sel = "badgesel";
        if (scheme != null) {
            sel = sel + scheme.code();
        }
        this.writeTagId(writer, badge);
        this.writeTagStyleClassWithTrailingExtraStyleClasses(writer, badge, sel);
        this.writeTagStyle(writer, badge);
        writer.write(">");
        if (StringUtils.isBlank((String)caption)) {
            caption = badge.getCaption();
        }
        if (caption != null) {
            writer.writeWithHtmlEscape(caption);
        }
        writer.write("</span>");
    }
}

