/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.TargetControl;
import com.tcdng.unify.web.ui.widget.control.Button;
import com.tcdng.unify.web.ui.widget.writer.AbstractTargetControlWriter;

@Writes(value=Button.class)
@Component(value="button-writer")
public class ButtonWriter
extends AbstractTargetControlWriter {
    @Override
    protected void doWriteTargetControl(ResponseWriter writer, TargetControl targetControl) throws UnifyException {
        Button button = (Button)targetControl;
        writer.write("<button type=\"button\"");
        this.writeTagAttributesWithTrailingExtraStyleClass(writer, button, "g_fsm");
        writer.write("/>");
        String imageSrc = (String)button.getUplAttribute(String.class, "imageSrc");
        String caption = button.getCaption();
        if (StringUtils.isNotBlank((String)imageSrc)) {
            writer.write("<img src=\"");
            writer.writeFileImageContextURL(imageSrc);
            writer.write("\">");
            if (caption != null) {
                writer.write("<span>");
                writer.writeWithHtmlEscape(caption);
                writer.write("</span>");
            }
        } else {
            String symbol;
            boolean isSymbol = false;
            if (this.isWithFontSymbolManager() && (isSymbol = !StringUtils.isBlank((String)(symbol = button.getSymbol())))) {
                writer.write(this.resolveSymbolHtmlHexCode(symbol));
            }
            if (caption != null) {
                if (isSymbol) {
                    writer.write("&nbsp;&nbsp;");
                }
                writer.writeWithHtmlEscape(caption);
            }
        }
        writer.write("</button>");
    }
}

