/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.data.Listable;
import com.tcdng.unify.web.ui.widget.PushType;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.control.CheckList;
import com.tcdng.unify.web.ui.widget.writer.AbstractControlWriter;
import java.util.List;

@Writes(value=CheckList.class)
@Component(value="checklist-writer")
public class CheckListWriter
extends AbstractControlWriter {
    @Override
    protected void doWriteStructureAndContent(ResponseWriter writer, Widget widget) throws UnifyException {
        CheckList checkList = (CheckList)widget;
        this.writeHiddenPush(writer, checkList, PushType.CHECKBOX);
        List<? extends Listable> listableList = checkList.getListables();
        int len = listableList.size();
        boolean appendSym = (Boolean)checkList.getUplAttribute(Boolean.TYPE, "flow") == false;
        boolean isContainerDisabled = checkList.isContainerDisabled();
        String baseId = checkList.getId();
        String baseFacId = checkList.getFacadeId();
        int breaks = len;
        for (int i = 0; i < len; ++i) {
            Listable listable = listableList.get(i);
            writer.write("<span ");
            this.writeTagId(writer, baseFacId + i);
            if (isContainerDisabled) {
                this.writeTagVisualAttributesWithTrailingExtraStyleClass(writer, checkList, "g_cbd");
            } else {
                this.writeTagVisualAttributesWithTrailingExtraStyleClass(writer, checkList, "g_cbb");
            }
            writer.write("/>");
            writer.write("<input type=\"checkbox\"");
            this.writeTagId(writer, baseId + i);
            this.writeTagName(writer, checkList);
            writer.write(" value=\"").write(listable.getListKey()).write("\"/>");
            writer.write("</span>");
            writer.writeWithHtmlEscape(listable.getListDescription());
            if (!appendSym || --breaks <= 0) continue;
            writer.write("<br />");
        }
    }

    @Override
    protected void doWriteBehavior(ResponseWriter writer, Widget widget) throws UnifyException {
        super.doWriteBehavior(writer, widget);
        CheckList checkList = (CheckList)widget;
        writer.beginFunction("ux.rigChecklist");
        writer.writeParam("pId", checkList.getId());
        writer.writeParam("pNm", checkList.getGroupId());
        writer.writeParam("pVal", checkList.getValue(String[].class));
        writer.writeParam("pActive", checkList.isActive());
        writer.endFunction();
    }
}

