/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.control.AbstractPopupTextField;
import com.tcdng.unify.web.ui.widget.control.DateField;
import com.tcdng.unify.web.ui.widget.control.DateFieldType;
import com.tcdng.unify.web.ui.widget.writer.control.AbstractPopupTextFieldWriter;
import java.util.Calendar;
import java.util.Date;

@Writes(value=DateField.class)
@Component(value="datefield-writer")
public class DateFieldWriter
extends AbstractPopupTextFieldWriter {
    @Override
    protected void writePopupContent(ResponseWriter writer, AbstractPopupTextField popupTextField) throws UnifyException {
        DateField dateField = (DateField)popupTextField;
        DateFieldType type = dateField.getType();
        writer.write("<div");
        this.writeTagId(writer, dateField.getPrefixedId("cal_"));
        this.writeTagStyleClass(writer, "dborder");
        writer.write(">");
        writer.write("<div class=\"cnav\">");
        if (type.supportsYear()) {
            this.writeButton(writer, dateField.getPrefixedId("decy_"), "cscroll", null, "<<");
        }
        this.writeButton(writer, dateField.getPrefixedId("decm_"), "cscroll", null, "<");
        writer.write("<div class=\"cdisplay\">");
        writer.write("<span");
        this.writeTagId(writer, dateField.getPrefixedId("disp1_"));
        writer.write("></span>");
        writer.write("<span");
        this.writeTagId(writer, dateField.getPrefixedId("disp2_"));
        writer.write("></span>");
        writer.write("</div>");
        this.writeButton(writer, dateField.getPrefixedId("incm_"), "cscroll", null, ">");
        if (type.supportsYear()) {
            this.writeButton(writer, dateField.getPrefixedId("incy_"), "cscroll", null, ">>");
        }
        writer.write("</div>");
        writer.write("<div style=\"position:relative;\">");
        writer.write("<div");
        this.writeTagId(writer, dateField.getPrefixedId("cont_"));
        this.writeTagStyleClass(writer, "ccontent");
        writer.write(">");
        writer.write("</div>");
        writer.write("<div");
        this.writeTagId(writer, dateField.getPrefixedId("month_"));
        this.writeTagStyleClass(writer, "clist");
        writer.write(">");
        writer.write("</div>");
        writer.write("<div");
        this.writeTagId(writer, dateField.getPrefixedId("year_"));
        this.writeTagStyleClass(writer, "clist");
        writer.write(">");
        writer.write("</div>");
        writer.write("</div>");
        writer.write("<div class=\"ccontrol\">");
        if (type.supportsYear()) {
            this.writeButton(writer, dateField.getPrefixedId("btnt_"), "cactbutton", "float:left;", this.getSessionMessage("button.today", new Object[0]));
        }
        this.writeButton(writer, dateField.getPrefixedId("btnc_"), "cactbutton", "float:right;", this.getSessionMessage("button.clear", new Object[0]));
        writer.write("</div>");
        writer.write("</div>");
    }

    @Override
    protected void doWritePopupTextFieldBehaviour(ResponseWriter writer, AbstractPopupTextField popupTextField, boolean popupEnabled) throws UnifyException {
        DateField dateField = (DateField)popupTextField;
        writer.beginFunction("ux.rigDateField");
        writer.writeParam("pId", dateField.getId());
        writer.writeParam("pDayClass", "cday");
        writer.writeParam("pDisableClass", "cdis");
        writer.writeParam("pCurrClass", "ccurrent");
        writer.writeParam("pTodayClass", "ctoday");
        writer.writeParam("pClearable", dateField.isClearable());
        writer.writeParam("pShortDayNm", dateField.getShortDayList());
        writer.writeParam("pLongMonthNm", dateField.getLongMonthList());
        writer.writeParam("pPattern", dateField.getPattern());
        writer.writeParam("pType", dateField.getType().toString().toLowerCase());
        Date date = dateField.getValue(Date.class);
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            writer.writeParam("pDay", cal.get(5));
            writer.writeParam("pMonth", cal.get(2));
            writer.writeParam("pYear", cal.get(1));
        }
        writer.writeParam("pEnabled", popupEnabled);
        writer.endFunction();
    }

    @Override
    protected String getOnShowAction() throws UnifyException {
        return null;
    }

    @Override
    protected String getOnShowParam(AbstractPopupTextField popupTextField) throws UnifyException {
        return null;
    }

    @Override
    protected String getOnHideAction() throws UnifyException {
        return null;
    }

    @Override
    protected String getOnHideParam(AbstractPopupTextField popupTextField) throws UnifyException {
        return null;
    }
}

