/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.constant.DrCrType;
import com.tcdng.unify.core.util.DataUtils;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.control.DebitCreditField;
import com.tcdng.unify.web.ui.widget.control.TextField;
import com.tcdng.unify.web.ui.widget.writer.control.NumberFieldWriter;
import java.math.BigDecimal;

@Writes(value=DebitCreditField.class)
@Component(value="debitcreditfield-writer")
public class DebitCreditFieldWriter
extends NumberFieldWriter {
    @Override
    protected void writeTrailingAddOn(ResponseWriter writer, Widget widget) throws UnifyException {
        DebitCreditField debitCreditField = (DebitCreditField)widget;
        writer.write("<button");
        this.writeTagId(writer, debitCreditField.getButtonId());
        if (!DrCrType.OPTIONAL.equals((Object)debitCreditField.getType()) || debitCreditField.isContainerDisabled() || !debitCreditField.isContainerEditable()) {
            writer.write(" disabled");
            this.writeTagStyleClass(writer, "tpbutton npoint");
        } else {
            this.writeTagStyleClass(writer, "tpbutton");
            this.writeTagTitle(writer, "Toggle (Dr <-> Cr");
        }
        writer.write(">");
        writer.write("</button>");
    }

    @Override
    protected String getFacadeStringValue(TextField textField) throws UnifyException {
        BigDecimal val = textField.getValue(BigDecimal.class);
        if (val != null) {
            return (String)DataUtils.convert(String.class, (Object)val.abs(), textField.getFormatter());
        }
        return null;
    }

    @Override
    protected String getFacadeHiddenStringValue(TextField textField) throws UnifyException {
        BigDecimal val = textField.getValue(BigDecimal.class);
        if (val != null) {
            return (String)DataUtils.convert(String.class, (Object)val, null);
        }
        return null;
    }

    @Override
    protected void doWriteBehavior(ResponseWriter writer, Widget widget) throws UnifyException {
        String[] stringArray;
        super.doWriteBehavior(writer, widget);
        DebitCreditField debitCreditField = (DebitCreditField)widget;
        String[] options = new String[]{"Dr", "Cr"};
        if (debitCreditField.isNegativeCredit()) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "";
            stringArray = stringArray2;
            stringArray2[1] = "-";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "-";
            stringArray = stringArray3;
            stringArray3[1] = "";
        }
        String[] prefixes = stringArray;
        DrCrType type = debitCreditField.getType();
        if (DrCrType.OPTIONAL.equals((Object)type)) {
            type = DrCrType.DEBIT;
            BigDecimal val = debitCreditField.getValue(BigDecimal.class);
            if (val != null) {
                boolean neg;
                boolean bl = neg = val.compareTo(BigDecimal.ZERO) < 0;
                if (debitCreditField.isNegativeCredit() && neg || !debitCreditField.isNegativeCredit() && !neg) {
                    type = DrCrType.CREDIT;
                }
            }
        }
        writer.beginFunction("ux.rigDebitCreditField");
        writer.writeParam("pId", debitCreditField.getId());
        writer.writeParam("pFacId", debitCreditField.getFacadeId());
        writer.writeParam("pBtnId", debitCreditField.getButtonId());
        writer.writeParam("pIndex", type.index());
        writer.writeParam("pPrefixes", prefixes);
        writer.writeParam("pOptions", options);
        writer.endFunction();
    }
}

