/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.constant.MimeType;
import com.tcdng.unify.core.util.DataUtils;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.control.DownloadLinkGrid;
import com.tcdng.unify.web.ui.widget.writer.AbstractControlWriter;
import java.util.List;

@Writes(value=DownloadLinkGrid.class)
@Component(value="downloadlinkgrid-writer")
public class DownloadLinkGridWriter
extends AbstractControlWriter {
    @Override
    protected void doWriteStructureAndContent(ResponseWriter writer, Widget widget) throws UnifyException {
        DownloadLinkGrid downloadLinkGrid = (DownloadLinkGrid)widget;
        writer.write("<div");
        this.writeTagAttributes(writer, downloadLinkGrid);
        writer.write(">");
        writer.write("<div><span class=\"dlgcatcap\">");
        writer.writeWithHtmlEscape(downloadLinkGrid.getCaption());
        writer.write("</span></div>");
        List<String> resourceList = downloadLinkGrid.getResourceList();
        if (DataUtils.isNotBlank(resourceList)) {
            writer.write("<div><table style=\"width:100%;\">");
            int columns = (Integer)downloadLinkGrid.getUplAttribute(Integer.TYPE, "columns");
            if (columns <= 0) {
                columns = 1;
            }
            Integer colWidth = 100 / columns;
            int len = resourceList.size();
            int i = 0;
            while (i < len) {
                writer.write("<tr>");
                int k = 0;
                while (k < columns) {
                    writer.write("<td style=\"width:").write(colWidth).write("%;\">");
                    if (i < len) {
                        String resourceName = resourceList.get(i);
                        writer.write("<a class=\"dlglink\" href=\"");
                        writer.writeContextResourceURL("/resource/downloadpath", MimeType.APPLICATION_OCTETSTREAM.template(), resourceName, null, true, false);
                        writer.write("\">");
                        writer.writeWithHtmlEscape(resourceName);
                        writer.write("</a>");
                    }
                    writer.write("</td>");
                    ++k;
                    ++i;
                }
                writer.write("</tr>");
            }
            writer.write("</table></div>");
        }
        writer.write("</div>");
    }
}

