/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.data.Listable;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.core.util.json.JsonWriter;
import com.tcdng.unify.web.ui.widget.ListControlInfo;
import com.tcdng.unify.web.ui.widget.PushType;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.control.AbstractPopupTextField;
import com.tcdng.unify.web.ui.widget.control.DropdownCheckList;
import com.tcdng.unify.web.ui.widget.writer.control.AbstractPopupTextFieldWriter;
import java.util.List;

@Writes(value=DropdownCheckList.class)
@Component(value="dropdownchecklist-writer")
public class DropdownCheckListWriter
extends AbstractPopupTextFieldWriter {
    @Override
    protected void writePopupContent(ResponseWriter writer, AbstractPopupTextField popupTextField) throws UnifyException {
        DropdownCheckList dropdownCheckList = (DropdownCheckList)popupTextField;
        List<? extends Listable> listableList = dropdownCheckList.getListables();
        int length = listableList.size();
        if (length > 0) {
            int columns = dropdownCheckList.getColumns();
            if (columns <= 0) {
                columns = 1;
            } else if (columns > length) {
                columns = length;
            }
            boolean isDisabled = dropdownCheckList.isDisabled();
            dropdownCheckList.setDisabled(dropdownCheckList.isContainerDisabled() || !dropdownCheckList.isContainerEditable());
            this.writeHiddenPush(writer, dropdownCheckList, PushType.CHECKBOX);
            boolean isContainerDisabled = dropdownCheckList.isContainerDisabled();
            writer.write("<div class=\"dclframe\"><table>");
            String selectAllOption = dropdownCheckList.getSelectAllOption();
            if (selectAllOption != null) {
                writer.write("<tr><td colspan=\"").write(columns * 2).write("\">");
                writer.write("<span ");
                this.writeTagId(writer, "fac_" + dropdownCheckList.getSelectAllId());
                if (isContainerDisabled) {
                    this.writeTagStyleClass(writer, "g_cbd");
                } else {
                    this.writeTagStyleClass(writer, "g_cbb");
                }
                writer.write("/>");
                writer.write("<input type=\"checkbox\"");
                this.writeTagId(writer, dropdownCheckList.getSelectAllId());
                writer.write("/>");
                writer.write("</span>");
                if (StringUtils.isNotBlank((String)selectAllOption)) {
                    writer.writeWithHtmlEscape(selectAllOption);
                } else {
                    writer.writeHtmlFixedSpace();
                }
                writer.write("</td></tr>");
            }
            String groupId = dropdownCheckList.getId();
            int i = 0;
            while (i < length) {
                writer.write("<tr>");
                int j = 0;
                while (j < columns) {
                    if (i < length) {
                        Listable listable = listableList.get(i);
                        writer.write("<td>");
                        String namingIndexId = dropdownCheckList.getNamingIndexedId(i);
                        writer.write("<span ");
                        this.writeTagId(writer, "fac_" + namingIndexId);
                        if (isContainerDisabled) {
                            this.writeTagStyleClass(writer, "g_cbd");
                        } else {
                            this.writeTagStyleClass(writer, "g_cbb");
                        }
                        writer.write("/>");
                        writer.write("<input type=\"checkbox\"");
                        this.writeTagId(writer, namingIndexId);
                        this.writeTagName(writer, groupId);
                        this.writeTagValue(writer, listable.getListKey());
                        writer.write("/>");
                        writer.write("</span>");
                        writer.write("</td><td>");
                        writer.writeWithHtmlEscape(listable.getListDescription());
                        writer.write("</td>");
                    } else {
                        writer.write("<td>&nbsp;</td><td>&nbsp;</td>");
                    }
                    ++j;
                    ++i;
                }
                writer.write("</tr>");
            }
            writer.write("</table></div>");
            dropdownCheckList.setDisabled(isDisabled);
        }
    }

    @Override
    protected void doWritePopupTextFieldBehaviour(ResponseWriter writer, AbstractPopupTextField popupTextField, boolean popupEnabled) throws UnifyException {
        DropdownCheckList dropdownCheckList = (DropdownCheckList)popupTextField;
        ListControlInfo listControlInfo = dropdownCheckList.getListControlInfo(popupTextField.getFormatter());
        writer.beginFunction("ux.rigDropdownChecklist");
        writer.writeParam("pId", dropdownCheckList.getId());
        writer.writeParam("pNm", dropdownCheckList.getId());
        writer.writeParam("pFacId", dropdownCheckList.getFacadeId());
        if (dropdownCheckList.getSelectAllOption() != null) {
            writer.writeParam("pSelAllId", dropdownCheckList.getSelectAllId());
        }
        writer.writeParam("pSelectIds", listControlInfo.getSelectIds());
        writer.writeParam("pKeys", listControlInfo.getKeys());
        writer.writeParam("pLabels", listControlInfo.getLabels());
        writer.writeParam("pVal", dropdownCheckList.getValue(String[].class));
        writer.writeParam("pEnabled", popupEnabled);
        writer.writeParam("pActive", popupEnabled);
        writer.endFunction();
    }

    @Override
    protected String getOnShowAction() throws UnifyException {
        return null;
    }

    @Override
    protected String getOnShowParam(AbstractPopupTextField popupTextField) throws UnifyException {
        return null;
    }

    @Override
    protected String getOnHideAction() throws UnifyException {
        return "ux.dcHidePopup";
    }

    @Override
    protected String getOnHideParam(AbstractPopupTextField popupTextField) throws UnifyException {
        DropdownCheckList dropdownCheckList = (DropdownCheckList)popupTextField;
        JsonWriter jw = new JsonWriter();
        jw.beginObject();
        jw.write("id", dropdownCheckList.getId());
        jw.endObject();
        return jw.toString();
    }
}

