/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.web.ui.widget.Control;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.control.DurationSelect;
import com.tcdng.unify.web.ui.widget.writer.AbstractControlWriter;

@Writes(value=DurationSelect.class)
@Component(value="durationselect-writer")
public class DurationSelectWriter
extends AbstractControlWriter {
    @Override
    protected void doWriteStructureAndContent(ResponseWriter writer, Widget widget) throws UnifyException {
        DurationSelect durationSelect = (DurationSelect)widget;
        writer.write("<div");
        this.writeTagStyleClass(writer, durationSelect);
        this.writeTagStyle(writer, durationSelect);
        writer.write(">");
        writer.write("<div class=\"dstable\">");
        writer.write("<div class=\"dsrow\">");
        if (durationSelect.isShowDays()) {
            this.writeFilter(writer, durationSelect.getDaySelCtrl(), this.resolveSessionMessage("$m{durationselect.days}", new Object[0]));
        }
        if (durationSelect.isShowHours()) {
            this.writeFilter(writer, durationSelect.getHourSelCtrl(), this.resolveSessionMessage("$m{durationselect.hours}", new Object[0]));
        }
        this.writeFilter(writer, durationSelect.getMinuteSelCtrl(), this.resolveSessionMessage("$m{durationselect.minutes}", new Object[0]));
        writer.write("</div></div>");
        writer.write("<input type=\"hidden\"");
        this.writeTagId(writer, durationSelect);
        this.writeTagName(writer, durationSelect);
        writer.write("/>");
        writer.write("</div>");
    }

    @Override
    protected void doWriteBehavior(ResponseWriter writer, Widget widget) throws UnifyException {
        super.doWriteBehavior(writer, widget);
        DurationSelect durationSelect = (DurationSelect)widget;
        if (durationSelect.isShowDays()) {
            writer.writeBehavior(durationSelect.getDaySelCtrl());
        }
        if (durationSelect.isShowHours()) {
            writer.writeBehavior(durationSelect.getHourSelCtrl());
        }
        writer.writeBehavior(durationSelect.getMinuteSelCtrl());
        writer.beginFunction("ux.rigDurationSelect");
        writer.writeParam("pId", durationSelect.getId());
        if (durationSelect.isShowDays()) {
            writer.writeParam("pDaySelId", durationSelect.getDaySelCtrl().getId());
        }
        if (durationSelect.isShowHours()) {
            writer.writeParam("pHourSelId", durationSelect.getHourSelCtrl().getId());
        }
        int duration = durationSelect.getValue(Integer.TYPE);
        duration -= duration % durationSelect.getMinuteJump();
        writer.writeParam("pMinSelId", durationSelect.getMinuteSelCtrl().getId());
        writer.writeParam("pVal", duration);
        writer.endFunction();
    }

    private void writeFilter(ResponseWriter writer, Control select, String caption) throws UnifyException {
        if (select != null) {
            writer.write("<div class=\"dscell\">");
            writer.writeStructureAndContent(select);
            writer.write("<span class=\"dslabel\">");
            writer.write(caption).write("</span>");
            writer.write("</div>");
        }
    }
}

