/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.constant.FileAttachmentType;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.control.FileUpload;
import com.tcdng.unify.web.ui.widget.writer.AbstractControlWriter;

@Writes(value=FileUpload.class)
@Component(value="fileupload-writer")
public class FileUploadWriter
extends AbstractControlWriter {
    @Override
    protected void doWriteStructureAndContent(ResponseWriter writer, Widget widget) throws UnifyException {
        FileAttachmentType fileAttachmentType;
        FileUpload fileUpload = (FileUpload)widget;
        writer.write("<div ");
        this.writeTagStyleClass(writer, fileUpload);
        boolean isHidden = fileUpload.isHidden();
        if (isHidden) {
            this.writeTagStyle(writer, "width:0px;height:0px;overflow:hidden;");
        } else {
            this.writeTagStyle(writer, fileUpload);
        }
        writer.write(">");
        if (!isHidden) {
            writer.write("<div style=\"width:0px;height:0px;overflow:hidden;\">");
        }
        writer.write("<input type=\"file\"");
        this.writeTagId(writer, fileUpload);
        String accept = fileUpload.getAccept();
        if (StringUtils.isNotBlank((String)accept) && (fileAttachmentType = FileAttachmentType.fromName((String)accept)) != null && !FileAttachmentType.WILDCARD.equals((Object)fileAttachmentType)) {
            writer.write(" accept=\"").write(fileAttachmentType.mimeType().template()).write(Character.valueOf('\"'));
        }
        if (((Boolean)fileUpload.getUplAttribute(Boolean.TYPE, "multiple")).booleanValue()) {
            writer.write(" multiple");
        }
        writer.write("/>");
        if (!isHidden) {
            writer.write("</div>");
        }
        if (!fileUpload.isHidden()) {
            writer.write("<div style=\"display:flex;width:100%;\">");
            if (!fileUpload.isSelectOnly()) {
                writer.write("<button type=\"button\" class=\"fubutton\" id=\"").write(fileUpload.getUploadButtonId());
                writer.write("\" style=\"background: url('");
                writer.writeFileImageContextURL("$t{images/upload.png}");
                writer.write("') no-repeat left 8px center/14px 14px;\">");
                writer.write("<span>");
                writer.writeWithHtmlEscape(fileUpload.getUploadCaption());
                writer.write("</span></button>");
            }
            writer.write("<button type=\"button\" class=\"fsbutton\" id=\"").write(fileUpload.getButtonId()).write("\">");
            writer.writeWithHtmlEscape(fileUpload.getBrowseCaption());
            writer.write("</button>");
            writer.write("<input type=\"text\" class=\"fsspan\" id=\"").write(fileUpload.getSpanId()).write("\" readonly />");
            writer.write("</div>");
        }
        writer.write("</div>");
    }

    @Override
    protected void doWriteBehavior(ResponseWriter writer, Widget widget) throws UnifyException {
        super.doWriteBehavior(writer, widget);
        FileUpload fileUpload = (FileUpload)widget;
        if (!fileUpload.isHidden()) {
            int maxSize;
            writer.beginFunction("ux.rigFileUpload");
            writer.writeParam("pId", fileUpload.getId());
            writer.writeParam("pContId", fileUpload.getContainerId());
            writer.writeParam("pBtnId", fileUpload.getButtonId());
            writer.writeParam("pSpanId", fileUpload.getSpanId());
            writer.writeParam("pUpBtnId", fileUpload.getUploadButtonId());
            writer.writeParam("pDisabled", fileUpload.isContainerDisabled());
            writer.writeParam("pSelect", fileUpload.isSelectOnly());
            String uploadPath = fileUpload.getUploadURL();
            if (uploadPath != null) {
                writer.writeContextURLParam("pUploadURL", uploadPath, new String[0]);
            }
            if ((maxSize = fileUpload.getMaxSize()) > 0) {
                writer.writeParam("pMaxSize", maxSize);
                writer.writeParam("pMaxMsg", this.getSessionMessage("fileupload.maxsize", new Object[]{maxSize}));
            }
            writer.endFunction();
        }
    }
}

