/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.data.ValueStore;
import com.tcdng.unify.web.ui.widget.AbstractMultiControl;
import com.tcdng.unify.web.ui.widget.PushType;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.control.GroupControl;
import com.tcdng.unify.web.ui.widget.writer.AbstractControlWriter;

@Writes(value=GroupControl.class)
@Component(value="group-writer")
public class GroupControlWriter
extends AbstractControlWriter {
    @Override
    protected void doWriteStructureAndContent(ResponseWriter writer, Widget widget) throws UnifyException {
        GroupControl groupControl = (GroupControl)widget;
        writer.write("<div");
        this.writeTagAttributes(writer, groupControl);
        writer.write(">");
        ValueStore valueStore = groupControl.getValueStore();
        boolean space = groupControl.isSpace();
        boolean appendSym = false;
        String dataGroupId = null;
        if (groupControl.isContainerEditable()) {
            dataGroupId = groupControl.getDataGroupId();
        }
        for (AbstractMultiControl.ChildWidgetInfo childWidgetInfo : groupControl.getChildWidgetInfos()) {
            if (!childWidgetInfo.isExternal()) continue;
            Widget chWidget = childWidgetInfo.getWidget();
            chWidget.setGroupId(dataGroupId);
            if (!chWidget.isVisible()) continue;
            if (space) {
                if (appendSym) {
                    writer.writeHtmlFixedSpace();
                } else {
                    appendSym = true;
                }
            }
            chWidget.setValueStore(valueStore);
            writer.writeStructureAndContent(chWidget);
        }
        if (dataGroupId != null) {
            this.writeHiddenPush(writer, dataGroupId, PushType.GROUP);
        }
        writer.write("</div>");
    }

    @Override
    protected void doWriteBehavior(ResponseWriter writer, Widget widget) throws UnifyException {
        GroupControl groupControl = (GroupControl)widget;
        super.doWriteBehavior(writer, groupControl);
        ValueStore valueStore = groupControl.getValueStore();
        for (AbstractMultiControl.ChildWidgetInfo childWidgetInfo : groupControl.getChildWidgetInfos()) {
            Widget chWidget;
            if (!childWidgetInfo.isExternal() || !(chWidget = childWidgetInfo.getWidget()).isVisible() && !chWidget.isHidden()) continue;
            chWidget.setValueStore(valueStore);
            writer.writeBehavior(chWidget);
        }
    }
}

