/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.resource.ImageGenerator;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.core.util.TokenUtils;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.TargetControl;
import com.tcdng.unify.web.ui.widget.control.Image;
import com.tcdng.unify.web.ui.widget.writer.AbstractTargetControlWriter;
import java.util.Date;

@Writes(value=Image.class)
@Component(value="image-writer")
public class ImageWriter
extends AbstractTargetControlWriter {
    @Override
    protected void doWriteTargetControl(ResponseWriter writer, TargetControl targetControl) throws UnifyException {
        Image imageCtrl = (Image)targetControl;
        writer.write("<img");
        this.writeTagAttributes(writer, imageCtrl);
        writer.write(" src=\"");
        Object image = imageCtrl.getValue();
        if (image instanceof ImageGenerator && !((ImageGenerator)image).isReady()) {
            image = null;
        }
        if (image != null) {
            String imageName = "Img_" + imageCtrl.getId() + '_' + new Date().getTime();
            this.setSessionAttribute(imageName, image);
            writer.writeScopeImageContextURL(imageName);
            writer.writeURLParameter("clearOnRead", "true");
        } else {
            String src = imageCtrl.getSrc();
            if (StringUtils.isNotBlank((String)src)) {
                boolean alwaysFetch = imageCtrl.isAlwaysFetch();
                if (TokenUtils.isContextScopeTag((String)src)) {
                    String imageName = TokenUtils.extractTokenValue((String)src);
                    writer.writeScopeImageContextURL(imageName);
                    String scope = imageCtrl.getScope();
                    if (StringUtils.isNotBlank((String)scope)) {
                        writer.writeURLParameter("scope", scope);
                    }
                    if (imageCtrl.isClearOnRead()) {
                        writer.writeURLParameter("clearOnRead", "true");
                    }
                    if (alwaysFetch) {
                        writer.writeURLParameter("morsic", String.valueOf(System.currentTimeMillis()));
                    }
                } else {
                    writer.writeFileImageContextURL(src);
                    if (alwaysFetch) {
                        writer.writeURLParameter("morsic", String.valueOf(System.currentTimeMillis()));
                    }
                }
            }
        }
        writer.write("\">");
    }
}

