/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.control.Label;
import com.tcdng.unify.web.ui.widget.writer.AbstractControlWriter;

@Writes(value=Label.class)
@Component(value="label-writer")
public class LabelWriter
extends AbstractControlWriter {
    @Override
    protected void doWriteStructureAndContent(ResponseWriter writer, Widget widget) throws UnifyException {
        String caption;
        Label label = (Label)widget;
        writer.write("<span");
        if (writer.isTableMode()) {
            this.writeTagStyle(writer, label);
        } else {
            this.writeTagAttributes(writer, label);
        }
        writer.write(">");
        String value = label.getStringValue();
        if (value != null) {
            if (label.isHtmlEscape()) {
                writer.writeWithHtmlEscape(value);
            } else {
                writer.write(value);
            }
        } else if (!label.isBindingOptional() && StringUtils.isNotBlank((String)label.getBinding())) {
            writer.writeHtmlFixedSpace();
        } else if (!label.isLayoutCaption() && (caption = label.getCaption()) != null) {
            if (label.isHtmlEscape()) {
                writer.writeWithHtmlEscape(caption);
            } else {
                writer.write(caption);
            }
        }
        writer.write("</span>");
    }

    @Override
    protected void doWriteBehavior(ResponseWriter writer, Widget widget) throws UnifyException {
        super.doWriteBehavior(writer, widget);
        Label label = (Label)widget;
        if (((Boolean)label.getUplAttribute(Boolean.TYPE, "draggable")).booleanValue()) {
            writer.beginFunction("ux.rigDragAndDropPopup");
            writer.writeParam("pId", label.getId());
            writer.endFunction();
        }
    }
}

