/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.control.LabeledText;
import com.tcdng.unify.web.ui.widget.writer.AbstractControlWriter;

@Writes(value=LabeledText.class)
@Component(value="labeledtext-writer")
public class LabeledTextWriter
extends AbstractControlWriter {
    @Override
    protected void doWriteStructureAndContent(ResponseWriter writer, Widget widget) throws UnifyException {
        LabeledText labeledText = (LabeledText)widget;
        writer.write("<div ");
        this.writeTagAttributes(writer, labeledText);
        writer.write(">");
        writer.write("<span class=\"lttitle\">");
        this.writeCaption(writer, labeledText);
        writer.write(":</span>&nbsp;");
        String valueString = labeledText.getStringValue();
        if ((Integer)labeledText.getUplAttribute(Integer.TYPE, "maxLen") > 0) {
            valueString = StringUtils.ellipsize((String)valueString, (int)((Integer)labeledText.getUplAttribute(Integer.TYPE, "maxLen")));
        }
        writer.write("<span class=\"ltcontent\">").writeWithHtmlEscape(valueString);
        writer.write("</span>&nbsp;");
        writer.write("</div>");
    }
}

