/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.util.DataUtils;
import com.tcdng.unify.core.util.json.JsonWriter;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.control.LinkGrid;
import com.tcdng.unify.web.ui.widget.data.LinkCategoryInfo;
import com.tcdng.unify.web.ui.widget.data.LinkGridInfo;
import com.tcdng.unify.web.ui.widget.data.LinkInfo;
import com.tcdng.unify.web.ui.widget.writer.AbstractControlWriter;
import java.util.List;

@Writes(value=LinkGrid.class)
@Component(value="linkgrid-writer")
public class LinkGridWriter
extends AbstractControlWriter {
    @Override
    protected void doWriteStructureAndContent(ResponseWriter writer, Widget widget) throws UnifyException {
        LinkGrid linkGrid = (LinkGrid)widget;
        writer.write("<div");
        this.writeTagAttributes(writer, linkGrid);
        writer.write(">");
        LinkGridInfo linkGridInfo = linkGrid.getValue(LinkGridInfo.class);
        if (linkGridInfo != null) {
            for (LinkCategoryInfo linkCategoryInfo : linkGridInfo.getLinkCategoryList()) {
                List<LinkInfo> linkInfoList;
                writer.write("<div>");
                String caption = linkCategoryInfo.getCaption();
                if (caption != null) {
                    writer.write("<div><span class=\"lgcatcap\">");
                    writer.writeWithHtmlEscape(caption);
                    writer.write("</span></div>");
                }
                if (DataUtils.isNotBlank(linkInfoList = linkCategoryInfo.getLinkInfoList())) {
                    writer.write("<div class=\"lgcatsec\"><table style=\"width:100%;\">");
                    String catName = linkGrid.getPrefixedId(linkCategoryInfo.getName());
                    int columns = (Integer)linkGrid.getUplAttribute(Integer.TYPE, "columns");
                    if (columns <= 0) {
                        columns = 1;
                    }
                    Integer colWidth = 100 / columns;
                    int len = linkInfoList.size();
                    int i = 0;
                    while (i < len) {
                        writer.write("<tr>");
                        int k = 0;
                        while (k < columns) {
                            writer.write("<td style=\"width:").write(colWidth).write("%;\">");
                            if (i < len) {
                                LinkInfo linkInfo = linkInfoList.get(i);
                                writer.write("<a class=\"lglink\"");
                                this.writeTagId(writer, catName + i);
                                writer.write(">");
                                writer.writeWithHtmlEscape(linkInfo.getCaption());
                                writer.write("</a>");
                            }
                            writer.write("</td>");
                            ++k;
                            ++i;
                        }
                        writer.write("</tr>");
                    }
                    writer.write("</table></div>");
                }
                writer.write("</div>");
            }
        }
        writer.write("</div>");
    }

    @Override
    protected void doWriteBehavior(ResponseWriter writer, Widget widget) throws UnifyException {
        super.doWriteBehavior(writer, widget);
        LinkGrid linkGrid = (LinkGrid)widget;
        writer.beginFunction("ux.rigLinkGrid");
        JsonWriter jw = new JsonWriter();
        jw.beginArray();
        LinkGridInfo linkGridInfo = linkGrid.getValue(LinkGridInfo.class);
        if (linkGridInfo != null) {
            for (LinkCategoryInfo linkCategoryInfo : linkGridInfo.getLinkCategoryList()) {
                jw.beginObject();
                jw.write("pURL", this.getContextURL(linkCategoryInfo.getPath(), new String[0]));
                jw.beginArray("links");
                List<LinkInfo> linkInfoList = linkCategoryInfo.getLinkInfoList();
                if (DataUtils.isNotBlank(linkInfoList)) {
                    String catName = linkGrid.getPrefixedId(linkCategoryInfo.getName());
                    int len = linkInfoList.size();
                    for (int i = 0; i < len; ++i) {
                        LinkInfo linkInfo = linkInfoList.get(i);
                        jw.beginObject();
                        jw.write("pId", catName + i);
                        jw.write("pCode", linkInfo.getCode());
                        jw.endObject();
                    }
                }
                jw.endArray();
                jw.endObject();
            }
        }
        jw.endArray();
        writer.writeParam("categories", jw);
        writer.endFunction();
    }
}

