/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.data.Listable;
import com.tcdng.unify.core.format.NumberFormatter;
import com.tcdng.unify.core.util.json.JsonWriter;
import com.tcdng.unify.web.ui.util.WebRegexUtils;
import com.tcdng.unify.web.ui.widget.ListControlInfo;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.control.AbstractPopupTextField;
import com.tcdng.unify.web.ui.widget.control.MoneyField;
import com.tcdng.unify.web.ui.widget.control.TextField;
import com.tcdng.unify.web.ui.widget.writer.control.AbstractPopupTextFieldWriter;
import java.util.List;

@Writes(value=MoneyField.class)
@Component(value="moneyfield-writer")
public class MoneyFieldWriter
extends AbstractPopupTextFieldWriter {
    @Override
    protected void writePopupContent(ResponseWriter writer, AbstractPopupTextField popupTextField) throws UnifyException {
        MoneyField moneyField = (MoneyField)popupTextField;
        writer.write("<div id=\"").write(moneyField.getFramePanelId()).write("\" class=\"mfborder\" style=\"overflow-y:auto;overflow-x:hidden;\" tabindex=\"-1\">");
        writer.write("<div id=\"").write(moneyField.getListPanelId()).write("\" class=\"mflist\">");
        List<? extends Listable> listableList = moneyField.getListables();
        int length = listableList.size();
        for (int i = 0; i < length; ++i) {
            Listable listable = listableList.get(i);
            writer.write("<a");
            this.writeTagId(writer, moneyField.getNamingIndexedId(i));
            writer.write(">");
            writer.writeWithHtmlEscape(listable.getListDescription());
            writer.write("</a>");
        }
        writer.write("</div>");
        writer.write("</div>");
    }

    @Override
    protected void doWritePopupTextFieldBehaviour(ResponseWriter writer, AbstractPopupTextField popupTextField, boolean popupEnabled) throws UnifyException {
        MoneyField moneyField = (MoneyField)popupTextField;
        writer.beginFunction("ux.rigMoneyField");
        writer.writeParam("pId", moneyField.getId());
        writer.writeParam("pFrmId", moneyField.getFramePanelId());
        writer.writeParam("pLstId", moneyField.getListPanelId());
        writer.writeParam("pBtnId", moneyField.getPopupButtonId());
        writer.writeParam("pFacId", moneyField.getFacadeId());
        if (moneyField.isMultiCurrency()) {
            ListControlInfo listControlInfo = moneyField.getListControlInfo(null);
            writer.writeParam("pICnt", listControlInfo.size());
            writer.writeParam("pSelectIds", listControlInfo.getSelectIds());
            writer.writeParam("pKeys", listControlInfo.getKeys());
            writer.writeParam("pLabels", listControlInfo.getLabels());
        } else {
            writer.writeParam("pICnt", 0);
        }
        writer.writeParam("pNormCls", "norm");
        writer.writeParam("pSelCls", this.getUserColorStyleClass("sel"));
        writer.writeParam("pEnabled", popupEnabled);
        JsonWriter jw = new JsonWriter();
        jw.beginObject();
        jw.write("currency", moneyField.getCurrencyString());
        jw.write("amount", moneyField.getAmountString());
        jw.endObject();
        writer.writeParam("pVal", jw);
        writer.endFunction();
    }

    @Override
    protected boolean isPopupEnabled(AbstractPopupTextField popupTextField) throws UnifyException {
        if (super.isPopupEnabled(popupTextField)) {
            MoneyField moneyField = (MoneyField)popupTextField;
            return moneyField.isMultiCurrency();
        }
        return false;
    }

    @Override
    protected void writeTrailingAddOn(ResponseWriter writer, Widget widget) throws UnifyException {
        MoneyField moneyField = (MoneyField)widget;
        writer.write("<button");
        this.writeTagId(writer, moneyField.getPopupButtonId());
        this.writeTagStyleClass(writer, "tplbutton");
        if (!this.isPopupEnabled(moneyField)) {
            writer.write(" disabled");
        }
        writer.write(">");
        writer.write("</button>");
    }

    @Override
    protected String getOnShowAction() throws UnifyException {
        return "ux.mfOnShow";
    }

    @Override
    protected String getOnShowParam(AbstractPopupTextField popupTextField) throws UnifyException {
        MoneyField moneyField = (MoneyField)popupTextField;
        JsonWriter jw = new JsonWriter();
        jw.beginObject();
        jw.write("pFrmId", moneyField.getFramePanelId());
        jw.endObject();
        return jw.toString();
    }

    @Override
    protected String getOnHideAction() throws UnifyException {
        return null;
    }

    @Override
    protected String getOnHideParam(AbstractPopupTextField popupTextField) throws UnifyException {
        return null;
    }

    @Override
    protected String getFormatRegex(TextField textField) throws UnifyException {
        MoneyField moneyField = (MoneyField)textField;
        int scale = 0;
        if (textField.isUplAttribute("scale")) {
            scale = (Integer)moneyField.getUplAttribute(Integer.TYPE, "scale");
        }
        return WebRegexUtils.getNumberFormatRegex(((NumberFormatter)moneyField.getFormatter()).getNumberSymbols(), (Integer)moneyField.getUplAttribute(Integer.TYPE, "precision"), scale, (Boolean)moneyField.getUplAttribute(Boolean.TYPE, "acceptNegative"), (Boolean)moneyField.getUplAttribute(Boolean.TYPE, "useGrouping"), false);
    }
}

