/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.data.Listable;
import com.tcdng.unify.web.ui.widget.ListControlInfo;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.control.MultiSelect;
import com.tcdng.unify.web.ui.widget.writer.AbstractControlWriter;
import java.util.ArrayList;
import java.util.List;

@Writes(value=MultiSelect.class)
@Component(value="multiselect-writer")
public class MultiSelectWriter
extends AbstractControlWriter {
    @Override
    protected void doWriteStructureAndContent(ResponseWriter writer, Widget widget) throws UnifyException {
        MultiSelect multiSelect = (MultiSelect)widget;
        writer.write("<div ");
        this.writeTagStyleClass(writer, multiSelect);
        this.writeTagStyle(writer, multiSelect);
        this.writeTagTitle(writer, multiSelect);
        writer.write("><div id=\"").write(multiSelect.getFramePanelId()).write("\" style=\"width:100%;height:100%;overflow-y:scroll;overflow-x:hidden;\" tabindex=\"-1\">");
        List<? extends Listable> listableList = multiSelect.getListables();
        int length = listableList.size();
        writer.write("<div id=\"").write(multiSelect.getListPanelId()).write("\" class=\"mslist\">");
        for (int i = 0; i < length; ++i) {
            writer.write("<a");
            this.writeTagId(writer, multiSelect.getNamingIndexedId(i));
            writer.write("\">");
            writer.write("</a>");
        }
        writer.write("</div>");
        writer.write("<select ");
        this.writeTagId(writer, multiSelect);
        this.writeTagStyle(writer, "display:none;");
        writer.write(" multiple=\"multiple\">");
        List values = multiSelect.getValue(ArrayList.class, String.class);
        for (Listable listable : listableList) {
            String key = listable.getListKey();
            writer.write("<option value=\"").write(key).write("\"");
            if (values != null && values.contains(key)) {
                writer.write(" selected");
            }
            writer.write("></option>");
        }
        writer.write("</select>");
        writer.write("</div>");
        writer.write("</div>");
    }

    @Override
    protected void doWriteBehavior(ResponseWriter writer, Widget widget) throws UnifyException {
        super.doWriteBehavior(writer, widget);
        MultiSelect multiSelect = (MultiSelect)widget;
        String pageName = multiSelect.getId();
        ListControlInfo listControlInfo = multiSelect.getListControlInfo(null);
        writer.beginFunction("ux.rigMultiSelect");
        writer.writeParam("pId", pageName);
        writer.writeParam("pFrmId", multiSelect.getFramePanelId());
        writer.writeParam("pLstId", multiSelect.getListPanelId());
        writer.writeParam("pSelectIds", listControlInfo.getSelectIds());
        writer.writeParam("pKeys", listControlInfo.getKeys());
        writer.writeParam("pLabels", listControlInfo.getLabels());
        writer.writeParam("pNormCls", "norm");
        writer.writeParam("pSelCls", this.getUserColorStyleClass("sel"));
        writer.writeParam("pVal", multiSelect.getValue(String[].class));
        writer.endFunction();
    }
}

