/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.data.Listable;
import com.tcdng.unify.web.ui.widget.PushType;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.control.RadioButtons;
import com.tcdng.unify.web.ui.widget.writer.AbstractControlWriter;
import java.util.List;

@Writes(value=RadioButtons.class)
@Component(value="radiobuttons-writer")
public class RadioButtonsWriter
extends AbstractControlWriter {
    @Override
    protected void doWriteStructureAndContent(ResponseWriter writer, Widget widget) throws UnifyException {
        RadioButtons radioButtons = (RadioButtons)widget;
        this.writeHiddenPush(writer, radioButtons, PushType.RADIO);
        List<? extends Listable> listableList = radioButtons.getListables();
        boolean isNotFlow = (Boolean)radioButtons.getUplAttribute(Boolean.TYPE, "flow") == false;
        int breaks = listableList.size();
        for (Listable listable : listableList) {
            writer.write("<input type=\"radio\"");
            this.writeTagName(writer, radioButtons);
            this.writeTagStyleClass(writer, radioButtons);
            this.writeTagStyle(writer, radioButtons);
            writer.write(" value=\"").write(listable.getListKey()).write("\"/>");
            writer.writeWithHtmlEscape(listable.getListDescription());
            if (!isNotFlow || --breaks <= 0) continue;
            writer.write("<br />");
        }
    }

    @Override
    protected void doWriteBehavior(ResponseWriter writer, Widget widget) throws UnifyException {
        super.doWriteBehavior(writer, widget);
        RadioButtons radioButtons = (RadioButtons)widget;
        writer.beginFunction("ux.rigRadioButtons");
        writer.writeParam("pId", radioButtons.getId());
        writer.writeParam("pNm", radioButtons.getGroupId());
        writer.writeParam("pVal", radioButtons.getValue(String.class));
        writer.endFunction();
    }
}

