/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.util.json.JsonWriter;
import com.tcdng.unify.web.ui.widget.ListControlInfo;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.control.AbstractPopupTextField;
import com.tcdng.unify.web.ui.widget.control.SearchField;
import com.tcdng.unify.web.ui.widget.writer.control.AbstractPopupTextFieldWriter;

@Writes(value=SearchField.class)
@Component(value="searchfield-writer")
public class SearchFieldWriter
extends AbstractPopupTextFieldWriter {
    @Override
    protected void writePopupContent(ResponseWriter writer, AbstractPopupTextField popupTextField) throws UnifyException {
        SearchField searchField = (SearchField)popupTextField;
        searchField.setKeyOnly(true);
        writer.write("<div");
        this.writeTagId(writer, searchField.getSearchPanelId());
        this.writeTagStyleClass(writer, "sfborder");
        writer.write(">");
        writer.write("<div");
        this.writeTagStyleClass(writer, "sffilterrow");
        writer.write(">");
        writer.write("<span>").write(searchField.getFilterLabel()).write("</span>");
        writer.write("<input type=\"text\"");
        this.writeTagId(writer, searchField.getFilterId());
        this.writeTagValue(writer, searchField.getFilter());
        writer.write("/>");
        writer.write("</div>");
        writer.write("<div");
        this.writeTagId(writer, searchField.getResultPanelId());
        this.writeTagStyleClass(writer, "sfresultrow");
        writer.write(">");
        this.writeResultList(writer, searchField);
        writer.write("</div>");
        writer.write("<div");
        this.writeTagStyleClass(writer, "sfactionrow");
        writer.write(">");
        this.writeButton(writer, searchField.getClearButtonId(), "sfactbutton", "float:left;", this.getSessionMessage("button.clear", new Object[0]));
        this.writeButton(writer, searchField.getCancelButtonId(), "sfactbutton", "float:right;", this.getSessionMessage("button.cancel", new Object[0]));
        writer.write("</div>");
        writer.write("</div>");
    }

    @Override
    protected void doWritePopupTextFieldBehaviour(ResponseWriter writer, AbstractPopupTextField popupTextField, boolean popupEnabled) throws UnifyException {
        SearchField searchField = (SearchField)popupTextField;
        searchField.setKeyOnly(true);
        this.writeRigging(writer, searchField, "ux.rigSearchField", popupEnabled);
    }

    @Override
    protected void doWriteSectionStructureAndContent(ResponseWriter writer, Widget widget, String sectionPageName) throws UnifyException {
        SearchField searchField = (SearchField)widget;
        if (searchField.getResultPanelId().equals(sectionPageName)) {
            this.writeResultList(writer, searchField);
        }
    }

    @Override
    protected void doWriteSectionBehavior(ResponseWriter writer, Widget widget, String sectionPageName) throws UnifyException {
        SearchField searchField = (SearchField)widget;
        if (searchField.getResultPanelId().equals(sectionPageName)) {
            this.writeRigging(writer, searchField, "ux.sfWireResult", this.isPopupEnabled(searchField));
        }
    }

    @Override
    protected String getOnShowAction() throws UnifyException {
        return "ux.sfOnShow";
    }

    @Override
    protected String getOnShowParam(AbstractPopupTextField popupTextField) throws UnifyException {
        SearchField searchField = (SearchField)popupTextField;
        JsonWriter jw = new JsonWriter();
        jw.beginObject();
        jw.write("pFilId", searchField.getFilterId());
        jw.endObject();
        return jw.toString();
    }

    @Override
    protected String getOnHideAction() throws UnifyException {
        return null;
    }

    @Override
    protected String getOnHideParam(AbstractPopupTextField popupTextField) throws UnifyException {
        return null;
    }

    private void writeRigging(ResponseWriter writer, SearchField searchField, String functionName, boolean popupEnabled) throws UnifyException {
        ListControlInfo listControlInfo = searchField.getListControlInfo(null);
        writer.beginFunction(functionName);
        writer.writeParam("pId", searchField.getId());
        writer.writeCommandURLParam("pCmdURL");
        writer.writeParam("pFacId", searchField.getFacadeId());
        writer.writeParam("pFilId", searchField.getFilterId());
        writer.writeParam("pRltId", searchField.getResultPanelId());
        writer.writeParam("pClrId", searchField.getClearButtonId());
        writer.writeParam("pCanId", searchField.getCancelButtonId());
        writer.writeParam("pClearable", searchField.isClearable());
        writer.writeParam("pICnt", listControlInfo.size());
        writer.writeParam("pSelectIds", listControlInfo.getSelectIds());
        writer.writeParam("pKeys", listControlInfo.getKeys());
        writer.writeParam("pLabels", listControlInfo.getLabels());
        writer.writeParam("pVal", searchField.getValue(String.class));
        writer.writeParam("pEnabled", popupEnabled);
        writer.endFunction();
    }

    private void writeResultList(ResponseWriter writer, SearchField searchField) throws UnifyException {
        ListControlInfo listControlInfo = searchField.getListControlInfo(null);
        int length = listControlInfo.size();
        writer.write("<div");
        this.writeTagStyleClass(writer, "sflist");
        writer.write(">");
        for (int i = 0; i < length; ++i) {
            writer.write("<a");
            this.writeTagId(writer, searchField.getNamingIndexedId(i));
            if (i % 2 == 0) {
                this.writeTagStyleClass(writer, "odd");
            } else {
                this.writeTagStyleClass(writer, "even");
            }
            writer.write(">");
            writer.write("</a>");
        }
        writer.write("</div>");
    }
}

