/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.data.Listable;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.core.util.json.JsonWriter;
import com.tcdng.unify.web.ui.widget.ListControlInfo;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.control.AbstractPopupTextField;
import com.tcdng.unify.web.ui.widget.control.SingleSelect;
import com.tcdng.unify.web.ui.widget.writer.control.AbstractPopupTextFieldWriter;
import java.util.List;

@Writes(value=SingleSelect.class)
@Component(value="singleselect-writer")
public class SingleSelectWriter
extends AbstractPopupTextFieldWriter {
    @Override
    protected void writePopupContent(ResponseWriter writer, AbstractPopupTextField popupTextField) throws UnifyException {
        SingleSelect singleSelect = (SingleSelect)popupTextField;
        writer.write("<div id=\"").write(singleSelect.getFramePanelId()).write("\" class=\"ssborder\" style=\"overflow-y:auto;overflow-x:hidden;\" tabindex=\"-1\">");
        writer.write("<div id=\"").write(singleSelect.getListPanelId()).write("\" class=\"sslist\">");
        List<? extends Listable> listableList = singleSelect.getListables();
        int length = listableList.size();
        String blankOption = singleSelect.getBlankOption();
        if (blankOption != null) {
            writer.write("<a id=\"").write(singleSelect.getBlankOptionId()).write("\">");
            if (StringUtils.isBlank((String)blankOption)) {
                writer.writeHtmlFixedSpace();
            } else {
                writer.writeWithHtmlEscape(blankOption);
            }
            writer.write("</a>");
        }
        for (int i = 0; i < length; ++i) {
            writer.write("<a");
            this.writeTagId(writer, singleSelect.getNamingIndexedId(i));
            writer.write(" class=\"norm\">");
            writer.write("</a>");
        }
        writer.write("</div>");
        writer.write("</div>");
    }

    @Override
    protected void doWritePopupTextFieldBehaviour(ResponseWriter writer, AbstractPopupTextField popupTextField, boolean popupEnabled) throws UnifyException {
        SingleSelect singleSelect = (SingleSelect)popupTextField;
        ListControlInfo listControlInfo = singleSelect.getListControlInfo(singleSelect.getFormatter());
        writer.beginFunction("ux.rigSingleSelect");
        writer.writeParam("pId", singleSelect.getId());
        writer.writeParam("pFacId", singleSelect.getFacadeId());
        writer.writeParam("pFrmId", singleSelect.getFramePanelId());
        writer.writeParam("pLstId", singleSelect.getListPanelId());
        writer.writeParam("pBlnkId", singleSelect.getBlankOptionId());
        writer.writeParam("pICnt", listControlInfo.size());
        writer.writeParam("pSelectIds", listControlInfo.getSelectIds());
        writer.writeParam("pKeys", listControlInfo.getKeys());
        writer.writeParam("pLabels", listControlInfo.getLabels());
        writer.writeParam("pIsBlankOption", singleSelect.getBlankOption() != null);
        writer.writeParam("pNormCls", "norm");
        writer.writeParam("pSelCls", this.getUserColorStyleClass("sel"));
        writer.writeParam("pEnabled", popupEnabled);
        writer.writeParam("pColors", singleSelect.isColors());
        writer.writeParam("pSelColId", singleSelect.getPopupButtonColorId());
        writer.writeParam("pVal", singleSelect.getStringValue());
        writer.endFunction();
    }

    @Override
    protected void writeTrailingAddOn(ResponseWriter writer, Widget widget) throws UnifyException {
        SingleSelect singleSelect = (SingleSelect)widget;
        if (singleSelect.isColors()) {
            AbstractPopupTextField popupTextField = (AbstractPopupTextField)widget;
            writer.write("<button tabindex=\"-1\"");
            this.writeTagId(writer, popupTextField.getPopupButtonId());
            this.writeTagStyleClass(writer, "tpbutton g_fsm");
            if (popupTextField.isContainerDisabled()) {
                writer.write(" disabled");
            }
            writer.write(">");
            writer.write("<span class=\"ssbcol\" style=\"background-color:");
            String val = singleSelect.getStringValue();
            if (StringUtils.isBlank((String)val)) {
                writer.write("transparent");
            } else {
                writer.write(val);
            }
            writer.write(";\" id=\"");
            writer.write(singleSelect.getPopupButtonColorId());
            writer.write("\"></span>");
            writer.write("</button>");
            return;
        }
        super.writeTrailingAddOn(writer, widget);
    }

    @Override
    protected String getOnShowAction() throws UnifyException {
        return "ux.ssOnShow";
    }

    @Override
    protected String getOnShowParam(AbstractPopupTextField popupTextField) throws UnifyException {
        SingleSelect singleSelect = (SingleSelect)popupTextField;
        JsonWriter jw = new JsonWriter();
        jw.beginObject();
        jw.write("pFrmId", singleSelect.getFramePanelId());
        jw.endObject();
        return jw.toString();
    }

    @Override
    protected String getOnHideAction() throws UnifyException {
        return null;
    }

    @Override
    protected String getOnHideParam(AbstractPopupTextField popupTextField) throws UnifyException {
        return null;
    }
}

