/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.UserToken;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.data.ValueStore;
import com.tcdng.unify.core.util.DataUtils;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.core.util.json.JsonWriter;
import com.tcdng.unify.web.ui.widget.Control;
import com.tcdng.unify.web.ui.widget.EventHandler;
import com.tcdng.unify.web.ui.widget.PushType;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.control.ColumnState;
import com.tcdng.unify.web.ui.widget.control.Table;
import com.tcdng.unify.web.ui.widget.writer.AbstractControlWriter;
import com.tcdng.unify.web.util.HtmlUtils;
import java.util.List;

@Writes(value=Table.class)
@Component(value="table-writer")
public class TableWriter
extends AbstractControlWriter {
    private static final String SELECT_CLASSNAME_BASE = "tsel";

    @Override
    protected void doWriteStructureAndContent(ResponseWriter writer, Widget widget) throws UnifyException {
        Table table = (Table)widget;
        table.pageCalculations();
        writer.write("<div");
        if (table.isContentEllipsis()) {
            this.writeTagStyleClassWithTrailingExtraStyleClasses(writer, table, "ui-table-cellipsis");
        } else {
            this.writeTagStyleClass(writer, table);
        }
        this.writeTagStyle(writer, table);
        writer.write(">");
        if (table.isWindowed()) {
            writer.write("<div");
            this.writeTagId(writer, table.getWinId());
            this.writeTagStyleClass(writer, "twin");
            this.writeTagStyle(writer, "display:table;table-layout:fixed;width:100%;height:100%;");
            writer.write(">");
            writer.write("<div style=\"display:table-row;\"><div style=\"display:table-cell;\">");
            writer.write("<div><table  class=\"thframe\" style=\"table-layout:fixed;width:100%;\"><tr><td><div style=\"overflow:hidden;\">");
            writer.write("<div");
            this.writeTagId(writer, table.getHeaderId());
            this.writeTagStyle(writer, "position:relative;");
            writer.write(">");
            writer.write("<table  class=\"thead\" style=\"table-layout:fixed;width:100%;\">");
            this.writeHeaderRow(writer, table);
            writer.write("</table></div>");
            writer.write("</div></td><td style=\"width:17px;\"></td></tr></table></div>");
            writer.write("</div></div>");
            writer.write("<div style=\"display:table-row;height:100%;\">");
            writer.write("<div");
            this.writeTagId(writer, table.getBodyCellId());
            this.writeTagStyle(writer, "height:100%;");
            writer.write(">");
            writer.write("<div");
            this.writeTagId(writer, table.getBodyId());
            this.writeTagStyleClass(writer, "tbody");
            this.writeTagStyle(writer, table.getBodyStyle());
            writer.write(">");
            writer.write("<span><table");
            this.writeTagId(writer, table);
            this.writeTagStyleClass(writer, "ttable tfixed");
            this.writeTagStyle(writer, "display:none;");
            writer.write(">");
            this.writeBodyRows(writer, table);
            writer.write("</table></span></div>");
            writer.write("</div></div>");
            if (table.isPagination()) {
                writer.write("<div style=\"display:table-row;\"><div style=\"display:table-cell;\">");
                this.writePaginationRow(writer, table);
                writer.write("</div></div>");
            }
            writer.write("</div>");
        } else {
            writer.write("<div>");
            writer.write("<div><table");
            this.writeTagId(writer, table);
            this.writeTagStyleClass(writer, "ttable");
            writer.write(">");
            this.writeHeaderRow(writer, table);
            this.writeBodyRows(writer, table);
            writer.write("</table></div>");
            if (table.isPagination()) {
                this.writePaginationRow(writer, table);
            }
            writer.write("</div>");
        }
        if (table.isMultiSelect()) {
            this.writeHiddenPush(writer, table.getSelectGroupId(), PushType.GROUP);
        }
        if (table.isContainerEditable()) {
            this.writeHiddenPush(writer, table.getDataGroupId(), PushType.GROUP);
        }
        writer.writeStructureAndContent(table.getViewIndexCtrl());
        if (table.isSortable()) {
            table.setColumnIndex(-1);
            writer.writeStructureAndContent(table.getColumnIndexCtrl());
            writer.writeStructureAndContent(table.getSortDirectionCtrl());
        }
        writer.write("</div>");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doWriteBehavior(ResponseWriter writer, Widget widget) throws UnifyException {
        int index;
        Control multiSelectCtrl;
        super.doWriteBehavior(writer, widget);
        Table table = (Table)widget;
        Control itemsPerPageCtrl = table.getItemsPerPageCtrl();
        if (itemsPerPageCtrl != null) {
            writer.writeBehavior(itemsPerPageCtrl);
        }
        if ((multiSelectCtrl = table.getMultiSelectCtrl()) != null) {
            multiSelectCtrl.setValueStore(null);
            multiSelectCtrl.setGroupId(null);
            writer.writeBehavior(multiSelectCtrl, table.getSelectAllId());
        }
        List writeRowList = table.getValueList();
        int lastIndex = index + table.getPageItemCount();
        for (index = table.getPageItemIndex(); index < lastIndex; ++index) {
            Table.RowValueStore itemValueStore = ((Table.Row)writeRowList.get(index)).getRowValueStore();
            if (multiSelectCtrl != null) {
                multiSelectCtrl.setValueStore((ValueStore)itemValueStore);
                writer.writeBehavior(multiSelectCtrl);
            }
            for (Table.Column column : table.getColumnList()) {
                if (!column.isVisible()) continue;
                Control control = column.getControl();
                control.setValueStore((ValueStore)itemValueStore);
                writer.writeBehavior(control);
            }
        }
        EventHandler[] rowEventHandlers = (EventHandler[])table.getUplAttribute(EventHandler[].class, "rowEventHandler");
        if (rowEventHandlers != null) {
            for (EventHandler eventHandler : rowEventHandlers) {
                writer.writeBehavior(eventHandler, table.getRowId(), null);
            }
        }
        if (table.isMultiSelect()) {
            // empty if block
        }
        writer.beginFunction("ux.rigTable");
        writer.writeParam("pId", table.getId());
        writer.writeParam("pContId", table.getContainerId());
        writer.writeCommandURLParam("pCmdURL");
        writer.writeParam("pIdxCtrlId", table.getViewIndexCtrl().getId());
        writer.writeParam("pBaseIdx", table.getPageItemIndex());
        writer.writeParam("pSelectable", table.isRowSelectable());
        if (table.isRowSelectable()) {
            writer.writeParam("pSelClassNm", this.getSelectClassName());
            writer.writeParam("pSelDepList", (String[])DataUtils.toArray(String.class, table.getSelDependentList()));
        }
        writer.writeParam("pWindowed", table.isWindowed());
        writer.writeParam("pPagination", table.isPagination());
        writer.writeParam("pItemCount", table.getPageItemCount());
        if (table.isPagination()) {
            writer.writeParam("pCurrPgCtrlId", table.getCurrentPageCtrl().getId());
            writer.writeParam("pItemPerPgCtrlId", table.getItemsPerPageCtrl().getId());
            writer.writeParam("pCurrPage", table.getCurrentPage());
            writer.writeParam("pPageCount", table.getTotalPages());
            writer.writeParam("pNaviStart", table.getNaviPageStart());
            writer.writeParam("pNaviStop", table.getNaviPageStop());
        }
        if (table.getPageItemCount() <= 0) {
            writer.writeParam("pConDepList", (String[])DataUtils.toArray(String.class, table.getContentDependentList()));
        }
        writer.writeParam("pMultiSel", table.isMultiSelect());
        if (table.isMultiSelect()) {
            String summarySrc;
            if (!table.isRowSelectable()) {
                writer.writeParam("pSelClassNm", this.getSelectClassName());
            }
            writer.writeParam("pSelAllId", table.getSelectAllId());
            writer.writeParam("pSelGrpId", table.getSelectGroupId());
            writer.writeParam("pVisibleSel", table.getPageSelectedRowCount());
            writer.writeParam("pHiddenSel", table.getSelectedRows() - table.getPageSelectedRowCount());
            writer.writeParam("pMultiSelDepList", (String[])DataUtils.toArray(String.class, table.getMultiSelDependentList()));
            int summaryColIndex = 1;
            if (table.isSerialNumbers()) {
                ++summaryColIndex;
            }
            if (StringUtils.isNotBlank((String)(summarySrc = table.getSummarySrc()))) {
                writer.writeParam("pSumSrc", summarySrc);
                writer.writeParam("pSumProcList", table.getSummaryProcList());
                writer.writeParam("pSumDepList", (String[])DataUtils.toArray(String.class, table.getSummaryDependentList()));
            }
            JsonWriter jw = new JsonWriter();
            jw.beginArray();
            for (Table.Column column : table.getColumnList()) {
                if (!column.isVisible()) continue;
                if (column.isColumnSelectSummary()) {
                    Control control = column.getControl();
                    jw.beginObject();
                    jw.write("idx", summaryColIndex);
                    jw.write("nm", control.getShortName());
                    jw.endObject();
                }
                ++summaryColIndex;
            }
            jw.endArray();
            writer.writeParam("pSumColList", jw);
        }
        boolean shiftable = table.getShiftDirectionId() != null;
        writer.writeParam("pShiftable", shiftable);
        if (shiftable) {
            writer.writeParam("pShiftDirId", table.getShiftDirectionId());
            writer.writeParam("pShiftTopId", table.getShiftTopId());
            writer.writeParam("pShiftUpId", table.getShiftUpId());
            writer.writeParam("pShiftDownId", table.getShiftDownId());
            writer.writeParam("pShiftBottomId", table.getShiftBottomId());
            writer.writeParam("pDeleteId", table.getDeleteId());
        }
        writer.writeParam("pSortable", table.isSortable());
        if (table.isSortable()) {
            void var13_25;
            writer.writeParam("pColIdxId", table.getColumnIndexCtrl().getId());
            writer.writeParam("pSortDirId", table.getSortDirectionCtrl().getId());
            writer.writeParam("pSortAscId", table.getAscImageCtrl().getId());
            writer.writeParam("pSortDescId", table.getDescImageCtrl().getId());
            JsonWriter jw = new JsonWriter();
            jw.beginArray();
            List<? extends ColumnState> columnStates = table.getColumnStates();
            boolean bl = false;
            while (var13_25 < columnStates.size()) {
                ColumnState columnState = columnStates.get((int)var13_25);
                if (columnState.isSortable()) {
                    jw.beginObject();
                    jw.write("idx", (int)var13_25);
                    jw.write("ascend", columnState.isAscending());
                    jw.write("field", columnState.getFieldName());
                    jw.endObject();
                }
                ++var13_25;
            }
            jw.endArray();
            writer.writeParam("pSortColList", jw);
        }
        writer.endFunction();
    }

    private void writeHeaderRow(ResponseWriter writer, Table table) throws UnifyException {
        boolean isHideMultiSelectBorder;
        writer.write("<tr>");
        table.clearVisibleColumnCount();
        if (table.isSerialNumbers()) {
            String snSym = table.getSerialNumberSymbol();
            if (snSym != null) {
                writer.write("<th class=\"thserialno tth\">").write(snSym).write("</th>");
            } else {
                writer.write("<th class=\"thserialno tth\"></th>");
            }
            table.incrementVisibleColumnCount();
        }
        boolean isMultiSelect = table.isMultiSelect();
        boolean isShowMultiSelectCheckboxes = table.isShowMultiSelectCheckboxes();
        boolean bl = isHideMultiSelectBorder = isMultiSelect && !isShowMultiSelectCheckboxes;
        if (isMultiSelect) {
            if (isShowMultiSelectCheckboxes) {
                writer.write("<th class=\"thselect tth\">");
            } else {
                writer.write("<th class=\"thselectx\">");
            }
            Control multiSelectCtrl = table.getMultiSelectCtrl();
            multiSelectCtrl.setValueStore(null);
            multiSelectCtrl.setGroupId(null);
            writer.writeStructureAndContent(multiSelectCtrl, table.getSelectAllId());
            writer.write("</th>");
            table.incrementVisibleColumnCount();
        }
        boolean isHeaderEllipsis = table.isHeaderEllipsis();
        for (Table.Column column : table.getColumnList()) {
            if (!column.isVisible()) continue;
            Control control = column.getControl();
            writer.write("<th");
            this.writeTagStyleClass(writer, "tth");
            String columnStyle = HtmlUtils.extractStyleAttribute((String)control.getColumnStyle(), (String)"width");
            if (isHideMultiSelectBorder) {
                columnStyle = columnStyle + "border-left:0px;";
                isHideMultiSelectBorder = false;
            }
            this.writeTagStyle(writer, columnStyle);
            if (isHeaderEllipsis) {
                writer.write("><span class=\"theadtitle theadellipsis\">");
            } else {
                writer.write("><span class=\"theadtitle\">");
            }
            String caption = control.getCaption();
            if (caption != null) {
                writer.write(caption);
            } else {
                writer.writeHtmlFixedSpace();
            }
            if (column.isSortable()) {
                writer.write("</span>&nbsp;&nbsp;<span class=\"theadwdg\">");
                Control imageCtrl = null;
                imageCtrl = column.isAscending() ? table.getAscImageCtrl() : table.getDescImageCtrl();
                writer.writeStructureAndContent(imageCtrl, imageCtrl.getPrefixedId(column.getFieldName() + '_'));
                writer.write("</span>");
            }
            writer.write("</th>");
            table.incrementVisibleColumnCount();
        }
        writer.write("</tr>");
    }

    private void writeBodyRows(ResponseWriter writer, Table table) throws UnifyException {
        if (table.getPageItemCount() > 0) {
            List writeRowList = table.getValueList();
            boolean isWindowed = table.isWindowed();
            int index = table.getPageItemIndex();
            int lastIndex = index + table.getPageItemCount();
            table.clearPageSelectedRowCount();
            boolean isSerialNo = table.isSerialNumbers();
            boolean isMultiSelect = table.isMultiSelect();
            boolean isContainerDisabled = table.isContainerDisabled();
            boolean isContainerEditable = table.isContainerEditable();
            boolean isShowMultiSelectCheckboxes = table.isShowMultiSelectCheckboxes();
            boolean isHideMultiSelectBorder = isMultiSelect && !isShowMultiSelectCheckboxes;
            String dataGroupId = null;
            if (isContainerEditable) {
                dataGroupId = table.getDataGroupId();
            }
            Control multiSelectCtrl = null;
            if (isMultiSelect) {
                multiSelectCtrl = table.getMultiSelectCtrl();
                multiSelectCtrl.setGroupId(table.getSelectGroupId());
            }
            for (Table.Column column : table.getColumnList()) {
                if (!column.isVisible()) continue;
                Control control = column.getControl();
                control.setDisabled(isContainerDisabled);
                control.setEditable(isContainerEditable);
                control.setGroupId(dataGroupId);
            }
            String columnStyle = null;
            boolean firstRowWrite = true;
            writer.setTableMode(true);
            while (index < lastIndex) {
                writer.write("<tr");
                if (index % 2 == 0) {
                    this.writeTagStyleClass(writer, "todd");
                } else {
                    this.writeTagStyleClass(writer, "teven");
                }
                this.writeTagName(writer, table.getRowId());
                writer.write(">");
                int columnIndex = 0;
                if (isSerialNo) {
                    writer.write("<td");
                    if (table.isWindowed()) {
                        this.writeTagStyleClass(writer, "thserialnol");
                    } else {
                        this.writeTagStyleClass(writer, "thserialno");
                    }
                    writer.write(">");
                    writer.write(index + 1);
                    writer.write(".</td>");
                    ++columnIndex;
                }
                Table.Row row = (Table.Row)writeRowList.get(index);
                Table.RowValueStore rowValueStore = row.getRowValueStore();
                if (isMultiSelect) {
                    if (row.isSelected()) {
                        table.incrementPageSelectedRowCount();
                    }
                    multiSelectCtrl.setValueStore((ValueStore)rowValueStore);
                    writer.write("<td");
                    if (isShowMultiSelectCheckboxes) {
                        if (table.isWindowed() && columnIndex == 0) {
                            this.writeTagStyleClass(writer, "thselectl");
                        } else {
                            this.writeTagStyleClass(writer, "thselect");
                        }
                        ++columnIndex;
                    } else {
                        this.writeTagStyleClass(writer, "thselectx");
                        columnIndex = 0;
                    }
                    writer.write(">");
                    writer.writeStructureAndContent(multiSelectCtrl);
                    writer.write("</td>");
                }
                for (Table.Column column : table.getColumnList()) {
                    if (!column.isVisible()) continue;
                    Control control = column.getControl();
                    control.setValueStore((ValueStore)rowValueStore);
                    writer.write("<td");
                    columnStyle = firstRowWrite ? control.getColumnStyle() : column.getStrippedStyle();
                    if (isWindowed || isHideMultiSelectBorder) {
                        if (columnIndex == 0) {
                            writer.write(" style=\"border-left:0px;");
                            if (StringUtils.isNotBlank((String)columnStyle)) {
                                writer.write(columnStyle);
                            }
                            writer.write("\"");
                        } else if (StringUtils.isNotBlank((String)columnStyle)) {
                            writer.write(" style=\"").write(columnStyle).write("\"");
                        }
                    } else {
                        this.writeTagStyle(writer, columnStyle);
                    }
                    writer.write(">");
                    writer.writeStructureAndContent(control);
                    writer.write("</td>");
                    ++columnIndex;
                }
                writer.write("</tr>");
                firstRowWrite = false;
                ++index;
            }
            writer.setTableMode(false);
        } else {
            writer.write("<tr class=\"tnoitems ").write(this.getSelectClassName()).write("\"><td");
            if (!table.isWindowed()) {
                writer.write(" colspan = \"").write(table.getVisibleColumnCount()).write(Character.valueOf('\"'));
            }
            writer.write(Character.valueOf('>'));
            writer.write(this.getSessionMessage("table.no.items.to.display", new Object[0]));
            writer.write("</td></tr>");
        }
    }

    private String getSelectClassName() throws UnifyException {
        UserToken userToken = this.getUserToken();
        if (userToken != null && StringUtils.isNotBlank((String)userToken.getColorScheme())) {
            return SELECT_CLASSNAME_BASE + userToken.getColorScheme();
        }
        return SELECT_CLASSNAME_BASE;
    }

    private void writePaginationRow(ResponseWriter writer, Table table) throws UnifyException {
        writer.write("<table class=\"tpagn\" style=\"table-layout:fixed;width:100%;\"><tr>");
        writer.write("<td class=\"tpnavleft\">");
        writer.write("<span>");
        if (table.getPageItemCount() > 0) {
            writer.write(this.getSessionMessage("table.items.of.total.displayed", new Object[]{table.getPageItemIndex() + 1, table.getPageItemIndex() + table.getPageItemCount(), table.getTotalItemCount()}));
        } else {
            writer.write(this.getSessionMessage("table.no.item.displayed", new Object[0]));
        }
        writer.write("</span>");
        writer.write("</td><td class=\"tpnavright\">");
        writer.write("<div>");
        writer.write("<div class=\"tpnavrightsec\">");
        writer.write("<span class=\"tpnavmsg\">").write(this.getSessionMessage("table.items.per.page", new Object[0])).write("</span>");
        writer.write("</div>");
        writer.write("<div class=\"tpnavrightsec\">");
        writer.writeStructureAndContent(table.getCurrentPageCtrl());
        writer.writeStructureAndContent(table.getItemsPerPageCtrl());
        writer.write("</div>");
        writer.write("<div class=\"tpnavrightsec\">");
        writer.write("<span");
        this.writeTagId(writer, table.getNavLeftId());
        this.writeTagStyleClass(writer, "tpnavpage");
        writer.write(">");
        writer.write("&lt;</span>");
        int naviPageStop = table.getNaviPageStop();
        String id = table.getId();
        int i = table.getNaviPageStart();
        while (i <= naviPageStop) {
            writer.write("&nbsp;<span id=\"nav_").write(id).write(i).write(Character.valueOf('\"'));
            if (i == table.getCurrentPage()) {
                this.writeTagStyleClass(writer, "tpnavcurr");
            } else {
                this.writeTagStyleClass(writer, "tpnavpage");
            }
            if (table.getPageItemCount() > 0) {
                writer.write(">").write(++i).write("</span>");
                continue;
            }
            writer.write(">").write(i++).write("</span>");
        }
        writer.writeHtmlFixedSpace();
        writer.write("<span");
        this.writeTagId(writer, table.getNavRightId());
        this.writeTagStyleClass(writer, "tpnavpage");
        writer.write(">");
        writer.write("&gt;</span>");
        writer.write("</div>");
        writer.write("</td>");
        writer.write("</tr></table>");
    }
}

