/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.control.TextArea;
import com.tcdng.unify.web.ui.widget.writer.AbstractControlWriter;
import java.util.Collection;

@Writes(value=TextArea.class)
@Component(value="textarea-writer")
public class TextAreaWriter
extends AbstractControlWriter {
    @Override
    protected void doWriteStructureAndContent(ResponseWriter writer, Widget widget) throws UnifyException {
        this.writeTextArea(writer, (TextArea)widget, null);
    }

    @Override
    protected void doWriteBehavior(ResponseWriter writer, Widget widget) throws UnifyException {
        super.doWriteBehavior(writer, widget);
        TextArea textArea = (TextArea)widget;
        writer.beginFunction("ux.rigTextArea");
        writer.writeParam("pId", textArea.getId());
        writer.writeParam("pScrEnd", textArea.isScrollToEnd());
        writer.endFunction();
    }

    protected void writeTextArea(ResponseWriter writer, TextArea textArea, String styleClass) throws UnifyException {
        int maxLen;
        int rows;
        writer.write("<textarea");
        if (StringUtils.isBlank((String)styleClass)) {
            this.writeTagAttributes(writer, textArea);
        } else {
            this.writeTagAttributesUsingStyleClass(writer, textArea, styleClass);
        }
        int columns = textArea.getColumns();
        if (columns > 0) {
            writer.write(" cols=\"").write(columns).write("\"");
        }
        if ((rows = textArea.getRows()) > 0) {
            writer.write(" rows=\"").write(rows).write("\"");
        }
        if ((maxLen = textArea.getMaxLen()) > 0) {
            writer.write(" maxlength=\"").write(maxLen).write("\"");
        }
        if (textArea.isWordWrap()) {
            writer.write(" wrap=\"virtual\"");
        } else {
            writer.write(" wrap=\"off\"");
        }
        writer.write(" spellcheck=\"").write(textArea.isSpellCheck()).write("\"");
        if (textArea.isAutoComplete()) {
            writer.write(" autocomplete=\"on\"");
        } else {
            writer.write(" autocomplete=\"nef\"");
        }
        if (textArea.getTabIndex() >= 0) {
            writer.write(" tabindex=\"").write(textArea.getTabIndex()).write("\"");
        }
        writer.write(">");
        Object value = textArea.getValue();
        if (value != null) {
            if (value instanceof String[]) {
                for (String line : (String[])value) {
                    writer.writeWithHtmlEscape(line);
                    writer.writeWithHtmlEscape("\n");
                }
            } else if (value instanceof Collection) {
                for (Object obj : (Collection)value) {
                    writer.writeWithHtmlEscape(String.valueOf(obj));
                    writer.writeWithHtmlEscape("\n");
                }
            } else {
                writer.writeWithHtmlEscape(textArea.getStringValue());
            }
        }
        writer.write("</textarea>");
    }
}

