/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.web.constant.ExtensionType;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.control.TextField;
import com.tcdng.unify.web.ui.widget.writer.AbstractControlWriter;

@Writes(value=TextField.class)
@Component(value="textfield-writer")
public class TextFieldWriter
extends AbstractControlWriter {
    @Override
    protected void doWriteStructureAndContent(ResponseWriter writer, Widget widget) throws UnifyException {
        TextField textField = (TextField)widget;
        this.writeTextField(writer, textField, "text");
    }

    @Override
    protected void doWriteBehavior(ResponseWriter writer, Widget widget) throws UnifyException {
        TextField textField = (TextField)widget;
        super.doWriteBehavior(writer, textField);
        writer.beginFunction("ux.setTextRegexFormatting");
        if (textField.isUseFacade()) {
            writer.writeParam("pId", textField.getFacadeId());
        } else {
            writer.writeParam("pId", textField.getId());
        }
        writer.writeResolvedParam("pRegex", "\"" + this.getFormatRegex(textField) + "\"");
        if (textField.getCase() != null) {
            writer.writeParam("pCase", textField.getCase().toString().toLowerCase());
        }
        writer.endFunction();
        if (!textField.getExtensionType().isExtended()) {
            this.writeValueAccessor(writer, textField);
        }
    }

    protected void writeTextField(ResponseWriter writer, TextField textField, String type) throws UnifyException {
        this.writeTextField(writer, textField, type, textField.getExtensionType());
    }

    protected void writeLeadingAddOn(ResponseWriter writer, Widget widget) throws UnifyException {
    }

    protected void writeTrailingAddOn(ResponseWriter writer, Widget widget) throws UnifyException {
    }

    protected void writeBaseAddOn(ResponseWriter writer, Widget widget) throws UnifyException {
    }

    protected String getFormatRegex(TextField textField) throws UnifyException {
        return "";
    }

    protected String getFacadeStringValue(TextField textField) throws UnifyException {
        return textField.getStringValue();
    }

    protected String getFacadeHiddenStringValue(TextField textField) throws UnifyException {
        return textField.getStringValue();
    }

    private void writeTextField(ResponseWriter writer, TextField textField, String type, ExtensionType extensionType) throws UnifyException {
        if (extensionType.isExtended()) {
            writer.write("<div ");
            this.writeTagId(writer, textField.getBorderId());
            this.writeTagStyleClass(writer, textField);
            this.writeTagStyle(writer, textField);
            writer.write(">");
            writer.write("<div style=\"display:flex;width:100%;\">");
            this.writeLeadingAddOn(writer, textField);
            if (extensionType.isFacadeHidden()) {
                writer.write("<input type=\"hidden\"");
                this.writeTagId(writer, textField);
                this.writeTagName(writer, textField);
                String value = this.getFacadeHiddenStringValue(textField);
                if (value != null) {
                    writer.write(" value=\"").writeWithHtmlEscape(value).write("\"");
                }
                writer.write("/>");
            }
            this.writeTextInput(writer, textField, type, extensionType);
            this.writeTrailingAddOn(writer, textField);
            writer.write("</div>");
            this.writeBaseAddOn(writer, textField);
            writer.write("</div>");
        } else {
            this.writeTextInput(writer, textField, type, extensionType);
        }
    }

    private void writeTextInput(ResponseWriter writer, TextField textField, String type, ExtensionType extensionType) throws UnifyException {
        writer.write("<input type=\"").write(type).write("\"");
        String value = null;
        if (extensionType.isExtended()) {
            if (extensionType.isFacade()) {
                this.writeTagId(writer, textField.getFacadeId());
                if (extensionType.isFacadeStringValue()) {
                    value = this.getFacadeStringValue(textField);
                }
            } else {
                this.writeTagId(writer, textField);
                this.writeTagName(writer, textField);
                value = textField.getStringValue();
            }
            this.writeTagStyleClass(writer, textField.getExtStyleClass());
            if (!extensionType.isEdit() && textField.getExtReadOnly()) {
                this.writeTagReadOnly(writer);
                this.writeTagDisabled(writer, textField);
            } else {
                this.writeTagEditAttributes(writer, textField);
            }
        } else {
            int maxLen;
            this.writeTagAttributes(writer, textField);
            value = textField.getStringValue();
            int size = (Integer)textField.getUplAttribute(Integer.TYPE, "size");
            if (size > 0) {
                writer.write(" size=\"").write(size).write("\"");
            }
            if ((maxLen = ((Integer)textField.getUplAttribute(Integer.TYPE, "maxLen")).intValue()) > 0) {
                writer.write(" maxlength=\"").write(maxLen).write("\"");
            }
        }
        if (value != null) {
            writer.write(" value=\"");
            writer.writeWithHtmlEscape(value);
            writer.write("\"");
        }
        writer.write(" spellcheck=\"").write(textField.isSpellCheck()).write("\"");
        if (textField.isAutoComplete()) {
            writer.write(" autocomplete=\"on\"");
        } else {
            writer.write(" autocomplete=\"nef\"");
        }
        if (textField.getTabIndex() >= 0) {
            writer.write(" tabindex=\"").write(textField.getTabIndex()).write("\"");
        }
        writer.write("/>");
    }
}

