/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.data.ValueStore;
import com.tcdng.unify.web.ui.widget.AbstractMultiControl;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.control.TitleBar;
import com.tcdng.unify.web.ui.widget.writer.AbstractControlWriter;

@Writes(value=TitleBar.class)
@Component(value="titlebar-writer")
public class TitleBarWriter
extends AbstractControlWriter {
    @Override
    protected void doWriteStructureAndContent(ResponseWriter writer, Widget widget) throws UnifyException {
        TitleBar titleBar = (TitleBar)widget;
        writer.write("<div");
        this.writeTagAttributes(writer, titleBar);
        writer.write(">");
        writer.write("<div class=\"").write(this.getUserColorStyleClass("base")).write("\">");
        writer.write("<div class=\"tblabel\">");
        this.writeCaption(writer, titleBar);
        writer.write("</div>");
        writer.write("<div class=\"tbcontrols\">");
        for (AbstractMultiControl.ChildWidgetInfo childWidgetInfo : titleBar.getChildWidgetInfos()) {
            if (!childWidgetInfo.isExternal() || !childWidgetInfo.isPrivilegeVisible()) continue;
            writer.writeStructureAndContent(childWidgetInfo.getWidget());
        }
        writer.write("</div>");
        writer.write("<div style=\"clear:both;\"></div>");
        writer.write("</div>");
        writer.write("</div>");
    }

    @Override
    protected void doWriteBehavior(ResponseWriter writer, Widget widget) throws UnifyException {
        super.doWriteBehavior(writer, widget);
        TitleBar titleBar = (TitleBar)widget;
        if (((Boolean)titleBar.getUplAttribute(Boolean.TYPE, "draggable")).booleanValue()) {
            writer.beginFunction("ux.rigDragAndDropPopup");
            writer.writeParam("pId", titleBar.getId());
            writer.endFunction();
        }
        ValueStore valueStore = titleBar.getValueStore();
        for (AbstractMultiControl.ChildWidgetInfo childWidgetInfo : titleBar.getChildWidgetInfos()) {
            if (!childWidgetInfo.isExternal() || !childWidgetInfo.isPrivilegeVisible()) continue;
            Widget chWidget = childWidgetInfo.getWidget();
            ValueStore origValueStore = chWidget.getValueStore();
            chWidget.setValueStore(valueStore);
            writer.writeBehavior(childWidgetInfo.getWidget());
            chWidget.setValueStore(origValueStore);
        }
    }
}

