/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.data.MarkedTree;
import com.tcdng.unify.core.util.DataUtils;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.core.util.json.JsonWriter;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.control.TreeExplorer;
import com.tcdng.unify.web.ui.widget.data.TreeItem;
import com.tcdng.unify.web.ui.widget.data.TreeItemTypeInfo;
import com.tcdng.unify.web.ui.widget.data.TreeMenuItemInfo;
import com.tcdng.unify.web.ui.widget.data.TreeTypeInfo;
import com.tcdng.unify.web.ui.widget.writer.AbstractControlWriter;
import java.util.ArrayList;
import java.util.List;

@Writes(value=TreeExplorer.class)
@Component(value="treeexplorer-writer")
public class TreeExplorerWriter
extends AbstractControlWriter {
    private final int PARENT_FLAG = 1;
    private final int EXPANDED_FLAG = 2;

    @Override
    protected void doWriteStructureAndContent(ResponseWriter writer, Widget widget) throws UnifyException {
        TreeExplorer treeExplorer = (TreeExplorer)widget;
        writer.write("<div");
        this.writeTagAttributes(writer, treeExplorer);
        writer.write(">");
        writer.write("<ul class=\"tlist\">");
        List<Long> selectedItemIds = treeExplorer.getSelectedItemIds();
        ArrayList<Long> visibleItemIds = new ArrayList<Long>();
        MarkedTree.Node<TreeItem> root = treeExplorer.getRootNode();
        if (root.isParent()) {
            this.writeChildListStructure(writer, treeExplorer, root, visibleItemIds, 0);
        }
        writer.write("</ul>");
        writer.write("<select ");
        this.writeTagId(writer, treeExplorer.getSelectedItemIdsCtrl());
        this.writeTagStyle(writer, "display:none;");
        writer.write(" multiple=\"multiple\">");
        for (Long itemId : visibleItemIds) {
            writer.write("<option value=\"").write(itemId).write("\"");
            if (selectedItemIds.contains(itemId)) {
                writer.write(" selected");
            }
            writer.write("></option>");
        }
        writer.write("</select>");
        writer.writeStructureAndContent(treeExplorer.getMenuCodeCtrl());
        writer.writeStructureAndContent(treeExplorer.getSelectedCtrlIdCtrl());
        writer.writeStructureAndContent(treeExplorer.getDropTrgItemIdCtrl());
        writer.writeStructureAndContent(treeExplorer.getDropSrcIdCtrl());
        writer.writeStructureAndContent(treeExplorer.getDropSrcItemIdsCtrl());
        writer.writeStructureAndContent(treeExplorer.getEventTypeCtrl());
        writer.write("</div>");
        if (treeExplorer.hasMenu()) {
            String menuId = treeExplorer.getMenuId();
            String sepId = treeExplorer.getMenuSeperatorId();
            writer.write("<div");
            this.writeTagId(writer, menuId);
            this.writeTagStyleClass(writer, "tree-popup");
            writer.write(">");
            writer.write("<ul id=\"").write(treeExplorer.getMenuBaseId()).write("\">");
            int i = 0;
            for (TreeMenuItemInfo menuItem : treeExplorer.getMenuItemInfoList()) {
                writer.write("<li id=\"").write(sepId + i).write("\" name=\"").write(sepId).write("\">");
                writer.write("<a class=\"mitem\" id=\"").write(menuId + i).write("\">");
                writer.writeWithHtmlEscape(this.resolveSessionMessage(menuItem.getCaption(), new Object[0]));
                writer.write("</a></li>");
                ++i;
            }
            writer.write("</ul>");
            writer.write("</div>");
        }
    }

    @Override
    protected void doWriteBehavior(ResponseWriter writer, Widget widget) throws UnifyException {
        super.doWriteBehavior(writer, widget);
        TreeExplorer treeExplorer = (TreeExplorer)widget;
        writer.beginFunction("ux.rigTreeExplorer");
        writer.writeParam("pId", treeExplorer.getId());
        writer.writeParam("pContId", treeExplorer.getContainerId());
        writer.writeCommandURLParam("pCmdURL");
        writer.writeParam("pSelCtrlId", treeExplorer.getSelectedCtrlIdCtrl().getId());
        writer.writeParam("pSelItemId", treeExplorer.getSelectedItemIdsCtrl().getId());
        writer.writeParam("pDropTrgItemId", treeExplorer.getDropTrgItemIdCtrl().getId());
        writer.writeParam("pDropSrcId", treeExplorer.getDropSrcIdCtrl().getId());
        writer.writeParam("pDropSrcItemId", treeExplorer.getDropSrcItemIdsCtrl().getId());
        writer.writeParam("pMenuCodeCtrlId", treeExplorer.getMenuCodeCtrl().getId());
        writer.writeParam("pEventTypeId", treeExplorer.getEventTypeCtrl().getId());
        writer.writeParam("pSel", "tsel");
        writer.writeParam("pNorm", "tnorm");
        writer.writeParam("pIco", "ticon");
        writer.writeParam("pIcod", "ticond");
        writer.writeParam("pCtrlBase", treeExplorer.getControlImgIdBase());
        writer.writeParam("pLblBase", treeExplorer.getCaptionIdBase());
        writer.writeParam("pIconBase", treeExplorer.getIconIdBase());
        List<String> pageNames = this.getPageManager().getExpandedReferences(treeExplorer.getId());
        if (!pageNames.isEmpty()) {
            writer.writeParam("pEventRef", (String[])DataUtils.toArray(String.class, pageNames));
        }
        if (treeExplorer.hasMenu()) {
            String getPathId = this.getRequestContextUtil().getResponsePathParts().getControllerPathId();
            writer.writeParam("pConfURL", this.getContextURL(getPathId, "/confirm"));
            String menuId = treeExplorer.getMenuId();
            String sepId = treeExplorer.getMenuSeperatorId();
            JsonWriter jwMenu = new JsonWriter();
            jwMenu.beginObject();
            jwMenu.write("id", menuId);
            jwMenu.write("normCls", "mnrm");
            jwMenu.write("sepCls", "msep");
            jwMenu.write("sepId", treeExplorer.getMenuSeperatorId());
            jwMenu.beginArray("items");
            int i = 0;
            for (TreeMenuItemInfo menuItem : treeExplorer.getMenuItemInfoList()) {
                jwMenu.beginObject();
                jwMenu.write("id", sepId + i);
                jwMenu.write("code", menuItem.getCode());
                jwMenu.write("grpIdx", menuItem.getGroupIndex());
                if (!StringUtils.isBlank((String)menuItem.getConfirm())) {
                    writer.write("pConf\":");
                    this.writeStringParameter(writer, this.resolveSessionMessage(menuItem.getConfirm(), new Object[0]));
                    jwMenu.write("pIconIndex", 3);
                }
                jwMenu.endObject();
                ++i;
            }
            jwMenu.endArray();
            jwMenu.endObject();
            writer.writeParam("pMenu", jwMenu);
            if (treeExplorer.isMultiSelectMenu()) {
                writer.writeParam("pMsMenu", (Number[])DataUtils.toArray(Integer.class, treeExplorer.getMultiSelectMenuSequence()));
            }
        }
        JsonWriter jwTypes = new JsonWriter();
        jwTypes.beginArray();
        for (TreeTypeInfo.ExtendedTreeItemTypeInfo extTypeInfo : treeExplorer.getExtendedTreeItemTypeInfos()) {
            TreeItemTypeInfo typeInfo = extTypeInfo.getTreeItemTypeInfo();
            jwTypes.beginObject();
            jwTypes.write("code", typeInfo.getCode());
            jwTypes.write("flags", typeInfo.getEventFlags());
            jwTypes.write("acceptdrop", (String[])DataUtils.toArray(String.class, typeInfo.getAcceptDropList()));
            jwTypes.write("menu", (Number[])DataUtils.toArray(Integer.class, extTypeInfo.getMenuSequence()));
            jwTypes.endObject();
        }
        jwTypes.endArray();
        writer.writeParam("pItemTypeList", jwTypes);
        JsonWriter jwItems = new JsonWriter();
        jwItems.beginArray();
        MarkedTree.Node<TreeItem> root = treeExplorer.getRootNode();
        if (root.isParent()) {
            this.writeChildListBehaviorItems(jwItems, treeExplorer, root);
        }
        jwItems.endArray();
        writer.writeParam("pItemList", jwItems);
        writer.endFunction();
    }

    private void writeChildListStructure(ResponseWriter writer, TreeExplorer tree, MarkedTree.Node<TreeItem> node, List<Long> visibleItemIds, int indent) throws UnifyException {
        MarkedTree.Node ch = node.getChild();
        List<Long> selectedItemIds = tree.getSelectedItemIds();
        String collapsedSrc = tree.getCollapsedIcon();
        String expandedSrc = tree.getExpandedIcon();
        String ctrlIdBase = tree.getControlImgIdBase();
        String captionIdBase = tree.getCaptionIdBase();
        String iconIdBase = tree.getIconIdBase();
        int chIndent = indent + 1;
        do {
            TreeItem treeItem = (TreeItem)ch.getItem();
            TreeItemTypeInfo treeItemTypeInfo = treeItem.getTypeInfo();
            Long itemId = ch.getMark();
            visibleItemIds.add(itemId);
            writer.write("<li>");
            for (int j = 0; j < indent; ++j) {
                this.writeIndent(writer);
            }
            if (ch.isParent()) {
                if (treeItem.isExpanded()) {
                    this.writeFileImageHtmlElement(writer, expandedSrc, ctrlIdBase + itemId, "timg", null);
                } else {
                    this.writeFileImageHtmlElement(writer, collapsedSrc, ctrlIdBase + itemId, "timg", null);
                }
            } else {
                this.writeIndent(writer);
            }
            writer.write("<span id=\"").write(captionIdBase).write(itemId);
            if (selectedItemIds.contains(itemId)) {
                writer.write("\" class=\"tsel\"");
            } else {
                writer.write("\" class=\"tnorm\"");
            }
            if (treeItemTypeInfo.isDraggable()) {
                writer.write(" draggable=\"true\">");
            } else {
                writer.write(">");
            }
            this.writeFileImageHtmlElement(writer, treeItemTypeInfo.getIcon(), iconIdBase + itemId, "ticon", null);
            writer.write("<span class=\"titem\">");
            writer.writeWithHtmlEscape(tree.getTreePolicy().getTreeItemCaption(treeItemTypeInfo, treeItem.getContent()));
            writer.write("</span></span>");
            writer.write("</li>");
            if (!ch.isParent() || !treeItem.isExpanded()) continue;
            this.writeChildListStructure(writer, tree, (MarkedTree.Node<TreeItem>)ch, visibleItemIds, chIndent);
        } while ((ch = ch.getNext()) != null);
    }

    private void writeChildListBehaviorItems(JsonWriter jwItems, TreeExplorer tree, MarkedTree.Node<TreeItem> node) throws UnifyException {
        MarkedTree.Node ch = node.getChild();
        do {
            TreeItem treeItem = (TreeItem)ch.getItem();
            TreeItemTypeInfo treeItemTypeInfo = treeItem.getTypeInfo();
            jwItems.beginObject();
            jwItems.write("idx", (Number)ch.getMark());
            jwItems.write("pidx", (Number)node.getMark());
            jwItems.write("type", treeItemTypeInfo.getCode());
            int flags = 0;
            if (ch.isParent()) {
                flags |= 1;
            }
            if (treeItem.isExpanded()) {
                flags |= 2;
            }
            jwItems.write("flags", flags);
            jwItems.endObject();
            if (!ch.isParent() || !treeItem.isExpanded()) continue;
            this.writeChildListBehaviorItems(jwItems, tree, (MarkedTree.Node<TreeItem>)ch);
        } while ((ch = ch.getNext()) != null);
    }

    private void writeIndent(ResponseWriter writer) throws UnifyException {
        writer.write("<span class=\"tindent\"></span>");
    }
}

