/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.layout;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.ui.widget.Container;
import com.tcdng.unify.web.ui.widget.Layout;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.TabularCellType;
import com.tcdng.unify.web.ui.widget.TabularLayout;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.writer.AbstractLayoutWriter;

public abstract class AbstractTabularLayoutWriter
extends AbstractLayoutWriter {
    @Override
    public void writeStructureAndContent(ResponseWriter writer, Layout layout, Container container) throws UnifyException {
        TabularLayout tabularLayout = (TabularLayout)layout;
        writer.write("<div");
        this.writeTagStyleClass(writer, "ui-tabular " + layout.getStyleClass());
        this.writeTagStyle(writer, layout.getStyle());
        writer.write(">");
        if (container.isRepeater()) {
            if (container.getRepeatValueStores() != null) {
                this.writeRepeatTableContent(writer, tabularLayout, container);
            }
        } else {
            this.writeTableContent(writer, tabularLayout, container);
        }
        writer.write("</div>");
    }

    protected void appendRowStart(ResponseWriter writer, TabularLayout layout, int rowIndex) throws UnifyException {
        writer.write("<div class=\"lrow\">");
    }

    protected void appendRowEnd(ResponseWriter writer) throws UnifyException {
        writer.write("</div>");
    }

    protected void appendCellContent(ResponseWriter writer, TabularLayout layout, Widget widget, int rowIndex, int columnIndex) throws UnifyException {
        String[] widths;
        String[] heights;
        TabularCellType cellType = layout.getCellType();
        String cellCls = cellType.styleClass();
        if (layout.isCellPadding()) {
            cellCls = cellType.padStyleClass();
        }
        writer.write("<div class=\"").write(cellCls).write("\"");
        boolean isStyle = false;
        String cellStyle = layout.getCellStyle();
        if (cellStyle != null) {
            isStyle = true;
            writer.write(" style=\"").write(cellStyle);
        }
        boolean isCaptionVisible = layout.isShowCaption();
        if (columnIndex == 0 && (heights = layout.getHeights()) != null && !"none".equals(heights[rowIndex])) {
            if (!isStyle) {
                writer.write(" style=\"");
                isStyle = true;
            }
            writer.write("height:").write(heights[rowIndex]).write(";");
        }
        if ((widths = layout.getWidths()) != null && !"none".equals(widths[columnIndex])) {
            if (!isStyle) {
                writer.write(" style=\"");
                isStyle = true;
            }
            writer.write("width:").write(widths[columnIndex]).write(";");
        }
        if (isStyle) {
            writer.write("\">");
        } else {
            writer.write(">");
        }
        if (isCaptionVisible) {
            String caption = null;
            boolean isCaption = widget.isLayoutCaption();
            if (isCaption) {
                caption = widget.getCaption();
                isCaption = StringUtils.isNotBlank((String)caption);
            }
            if (isCaption) {
                String captionCls = "llabel";
                if (layout.isInlineCaption()) {
                    String inlineCapClass = layout.getInlineCaptionClass();
                    captionCls = inlineCapClass == null ? "llabelinl" : "llabelinl " + inlineCapClass;
                }
                writer.write("<div");
                this.writeTagStyleClass(writer, captionCls);
                this.writeTagStyle(writer, layout.getCaptionStyle());
                writer.write(">");
                writer.write(caption);
                writer.writeNotNull(layout.getCaptionSuffix());
                writer.write("</div>");
            } else {
                writer.write("<div class=\"llabelblank\"></div>");
            }
        }
        String contentCls = "lcontent";
        if (layout.isInlineCaption()) {
            contentCls = "lcontentinl";
        }
        writer.write("<div class=\"").write(contentCls).write("\">");
        writer.writeStructureAndContent(widget);
        writer.write("</div>");
        writer.write("</div>");
    }

    protected abstract void writeTableContent(ResponseWriter var1, TabularLayout var2, Container var3) throws UnifyException;

    protected abstract void writeRepeatTableContent(ResponseWriter var1, TabularLayout var2, Container var3) throws UnifyException;
}

