/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.layout;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.web.ui.widget.Document;
import com.tcdng.unify.web.ui.widget.DocumentLayout;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.layout.DesktopType2Layout;
import com.tcdng.unify.web.ui.widget.writer.layout.AbstractDocumentLayoutWriter;

@Writes(value=DesktopType2Layout.class)
@Component(value="desktoptype2-writer")
public class DesktopType2LayoutWriter
extends AbstractDocumentLayoutWriter {
    @Override
    public void writeBehaviour(ResponseWriter writer, DocumentLayout layout, Document document) throws UnifyException {
        boolean isCollapsible = (Boolean)layout.getUplAttribute(Boolean.TYPE, "collapsibleSidebar");
        if (isCollapsible) {
            String docPageName = document.getId();
            writer.beginFunction("ux.rigDesktopType2");
            writer.writeParam("pId", docPageName);
            writer.writeParam("pMenuId", docPageName + "_menu");
            writer.writeParam("pGripId", docPageName + "_grip");
            writer.writeParam("pOpen", true);
            writer.endFunction();
        }
    }

    @Override
    protected void writeInnerStructureAndContent(ResponseWriter writer, DocumentLayout layout, Document document) throws UnifyException {
        boolean isCollapsible = (Boolean)layout.getUplAttribute(Boolean.TYPE, "collapsibleSidebar");
        String docPageName = document.getId();
        this.writeSection(writer, "header", document.getHeaderPanel());
        writer.write("<div class=\"midSection\">");
        writer.write("<div class=\"cell\">");
        writer.write("<div style=\"display:table; width:100%; height:100%\">");
        writer.write("<div style=\"display:table-row; width:100%;\">");
        writer.write("<div id=\"").write(docPageName).write("_menu\" class=\"menuopen\">");
        if (document.getMenuPanel() != null) {
            writer.writeStructureAndContent(document.getMenuPanel());
        }
        writer.write("</div>");
        if (isCollapsible) {
            writer.write("<div class=\"collapser\">");
            writer.write("<span id=\"").write(docPageName).write("_grip\" class=\"grip\"/>");
            writer.write("</div>");
        }
        writer.write("<div class=\"content\">");
        writer.writeStructureAndContent(document.getContentPanel());
        writer.write("</div>");
        writer.write("</div>");
        writer.write("</div>");
        writer.write("</div>");
        writer.write("</div>");
        this.writeSection(writer, "footer", document.getFooterPanel());
    }
}

