/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.layout;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.ui.widget.Container;
import com.tcdng.unify.web.ui.widget.Layout;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.layout.FlowGridLayout;
import com.tcdng.unify.web.ui.widget.writer.AbstractLayoutWriter;

@Writes(value=FlowGridLayout.class)
@Component(value="flowgridlayout-writer")
public class FlowGridLayoutWriter
extends AbstractLayoutWriter {
    @Override
    public void writeStructureAndContent(ResponseWriter writer, Layout layout, Container container) throws UnifyException {
        FlowGridLayout flowGridLayout = (FlowGridLayout)layout;
        writer.write("<div");
        this.writeTagStyleClass(writer, flowGridLayout.getStyleClass());
        String style = "grid-template-columns:repeat(auto-fill, minmax(" + flowGridLayout.getMinColumnWidth() + ", 1fr));";
        if (!StringUtils.isBlank((String)flowGridLayout.getStyle())) {
            style = style + flowGridLayout.getStyle();
        }
        this.writeTagStyle(writer, style);
        writer.write(">");
        boolean isAlternate = container.isAlternate();
        for (String longName : container.getLayoutWidgetLongNames()) {
            Widget widget = container.getWidgetByLongName(longName);
            widget.setAlternateMode(isAlternate);
            if (widget.isVisible()) {
                writer.write("<div class=\"fgcell\">");
                if (flowGridLayout.isShowCaption()) {
                    String caption = null;
                    boolean isCaption = widget.isLayoutCaption();
                    if (isCaption) {
                        caption = widget.getCaption();
                        isCaption = StringUtils.isNotBlank((String)caption);
                    }
                    if (isCaption) {
                        String captionCls = "llabel";
                        if (layout.isInlineCaption()) {
                            captionCls = "llabelinl";
                        }
                        writer.write("<div");
                        this.writeTagStyleClass(writer, captionCls);
                        this.writeTagStyle(writer, layout.getCaptionStyle());
                        writer.write(">");
                        writer.write(caption);
                        writer.writeNotNull(layout.getCaptionSuffix());
                        writer.write("</div>");
                    } else {
                        writer.write("<div class=\"llabelblank\"></div>");
                    }
                }
                String contentCls = "lcontent";
                if (layout.isInlineCaption()) {
                    contentCls = "lcontentinl";
                }
                writer.write("<div class=\"").write(contentCls).write("\">");
                writer.writeStructureAndContent(widget);
                writer.write("</div>");
                writer.write("</div>");
                continue;
            }
            if (!widget.isHidden()) continue;
            writer.writeStructureAndContent(widget);
        }
        writer.write("</div>");
    }
}

