/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.layout;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.data.ValueStore;
import com.tcdng.unify.web.ui.widget.Container;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.TabularLayout;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.layout.GridLayout;
import com.tcdng.unify.web.ui.widget.writer.layout.AbstractTabularLayoutWriter;

@Writes(value=GridLayout.class)
@Component(value="gridlayout-writer")
public class GridLayoutWriter
extends AbstractTabularLayoutWriter {
    @Override
    protected void writeTableContent(ResponseWriter writer, TabularLayout layout, Container container) throws UnifyException {
        GridLayout gridLayout = (GridLayout)layout;
        int columnIndex = 0;
        int rowIndex = 0;
        int columns = (Integer)gridLayout.getUplAttribute(Integer.TYPE, "columns");
        if (columns <= 0) {
            columns = 1;
        }
        boolean isAlternate = container.isAlternate();
        for (String longName : container.getLayoutWidgetLongNames()) {
            Widget widget = container.getWidgetByLongName(longName);
            widget.setAlternateMode(isAlternate);
            if (widget.isVisible()) {
                if (columnIndex == 0) {
                    writer.write("<div class=\"lrow\">");
                }
                this.appendCellContent(writer, gridLayout, widget, rowIndex, columnIndex);
                if (++columnIndex != columns) continue;
                writer.write("</div>");
                ++rowIndex;
                columnIndex = 0;
                continue;
            }
            if (!widget.isHidden()) continue;
            writer.writeStructureAndContent(widget);
        }
        if (columnIndex > 0) {
            while (columnIndex++ < columns) {
                writer.write("<div class=\"lcellm\">&nbsp;</div>");
            }
            writer.write("</div>");
        }
    }

    @Override
    protected void writeRepeatTableContent(ResponseWriter writer, TabularLayout layout, Container container) throws UnifyException {
        GridLayout gridLayout = (GridLayout)layout;
        int columnIndex = 0;
        int rowIndex = 0;
        int columns = gridLayout.getColumns();
        if (columns <= 0) {
            columns = 1;
        }
        Widget widget = container.getWidgetByLongName(container.getLayoutWidgetLongNames().get(0));
        boolean isAlternate = container.isAlternate();
        for (ValueStore valueStore : container.getRepeatValueStores()) {
            widget.setValueStore(valueStore);
            widget.setAlternateMode(isAlternate);
            if (widget.isVisible()) {
                if (columnIndex == 0) {
                    writer.write("<div class=\"lrow\">");
                }
                this.appendCellContent(writer, gridLayout, widget, rowIndex, columnIndex);
                if (++columnIndex != columns) continue;
                writer.write("</div>");
                ++rowIndex;
                columnIndex = 0;
                continue;
            }
            if (!widget.isHidden()) continue;
            writer.writeStructureAndContent(widget);
        }
        if (columnIndex > 0) {
            while (columnIndex++ < columns) {
                writer.write("<div class=\"lcellm\">&nbsp;</div>");
            }
            writer.write("</div>");
        }
    }
}

