/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.layout;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.data.ValueStore;
import com.tcdng.unify.web.ui.widget.Container;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.TabularLayout;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.layout.HorizontalLayout;
import com.tcdng.unify.web.ui.widget.writer.layout.AbstractTabularLayoutWriter;

@Writes(value=HorizontalLayout.class)
@Component(value="horizontallayout-writer")
public class HorizontalLayoutWriter
extends AbstractTabularLayoutWriter {
    @Override
    protected void writeTableContent(ResponseWriter writer, TabularLayout layout, Container container) throws UnifyException {
        int columnIndex = 0;
        this.appendRowStart(writer, layout, 0);
        boolean isAlternate = container.isAlternate();
        for (String longName : container.getLayoutWidgetLongNames()) {
            Widget widget = container.getWidgetByLongName(longName);
            widget.setAlternateMode(isAlternate);
            if (widget.isVisible()) {
                this.appendCellContent(writer, layout, widget, 0, columnIndex++);
                continue;
            }
            if (!widget.isHidden()) continue;
            writer.writeStructureAndContent(widget);
        }
        this.appendRowEnd(writer);
    }

    @Override
    protected void writeRepeatTableContent(ResponseWriter writer, TabularLayout layout, Container container) throws UnifyException {
        int columnIndex = 0;
        this.appendRowStart(writer, layout, 0);
        Widget widget = container.getWidgetByLongName(container.getLayoutWidgetLongNames().get(0));
        boolean isAlternate = container.isAlternate();
        for (ValueStore valueStore : container.getRepeatValueStores()) {
            widget.setValueStore(valueStore);
            widget.setAlternateMode(isAlternate);
            if (widget.isVisible()) {
                this.appendCellContent(writer, layout, widget, 0, columnIndex++);
                continue;
            }
            if (!widget.isHidden()) continue;
            writer.writeStructureAndContent(widget);
        }
        this.appendRowEnd(writer);
    }
}

