/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.layout;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.ui.widget.Container;
import com.tcdng.unify.web.ui.widget.Control;
import com.tcdng.unify.web.ui.widget.Layout;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.layout.ShadedListLayout;
import com.tcdng.unify.web.ui.widget.writer.AbstractLayoutWriter;

@Writes(value=ShadedListLayout.class)
@Component(value="shadedlistlayout-writer")
public class ShadedListLayoutWriter
extends AbstractLayoutWriter {
    @Override
    public void writeStructureAndContent(ResponseWriter writer, Layout layout, Container container) throws UnifyException {
        ShadedListLayout shadedListLayout = (ShadedListLayout)layout;
        writer.write("<table");
        this.writeTagStyleClass(writer, shadedListLayout.getStyleClass());
        this.writeTagStyle(writer, shadedListLayout.getStyle());
        writer.write(">");
        boolean isAlternate = container.isAlternate();
        if (shadedListLayout.isInlineMode()) {
            writer.write("<tr>");
            int colWidth = 100;
            int minColumns = shadedListLayout.minColumns();
            int itemCount = container.getLayoutWidgetLongNames().size();
            if (itemCount < minColumns) {
                itemCount = minColumns;
            }
            if (itemCount > 0) {
                colWidth /= itemCount;
            }
            for (String longName : container.getLayoutWidgetLongNames()) {
                Widget widget = container.getWidgetByLongName(longName);
                writer.write("<td class=\"islbase");
                this.writeLayoutColor(writer, widget);
                writer.write("\" style=\"width:").write(colWidth).write("%;\">");
                if (widget.isVisible()) {
                    widget.setAlternateMode(isAlternate);
                    writer.write("<span class=\"islcap\">");
                    String caption = widget.getCaption();
                    if (StringUtils.isNotBlank((String)caption)) {
                        writer.write(caption);
                        if (caption.charAt(caption.length() - 1) != '?') {
                            writer.writeNotNull(shadedListLayout.getCaptionSuffix());
                        }
                    }
                    writer.write("</span>");
                    writer.writeStructureAndContent(widget);
                }
                writer.write("</td>");
                --minColumns;
            }
            while (--minColumns >= 0) {
                writer.write("<td class=\"islbase\" style=\"width:").write(colWidth).write("%;\"></td>");
            }
            writer.write("</tr>");
        } else {
            for (String longName : container.getLayoutWidgetLongNames()) {
                Widget widget = container.getWidgetByLongName(longName);
                if (!widget.isVisible()) continue;
                widget.setAlternateMode(isAlternate);
                writer.write("<tr>");
                if (shadedListLayout.isShowCaption()) {
                    writer.write("<td class=\"slcap\">");
                    if (StringUtils.isNotBlank((String)widget.getCaption())) {
                        writer.write(widget.getCaption());
                        writer.writeNotNull(shadedListLayout.getCaptionSuffix());
                    }
                    writer.write("</td>");
                }
                writer.write("<td class=\"slcnt");
                this.writeLayoutColor(writer, widget);
                writer.write("\">");
                writer.writeStructureAndContent(widget);
                writer.write("</td>");
                writer.write("</tr>");
            }
        }
        writer.write("</table>");
    }

    private void writeLayoutColor(ResponseWriter writer, Widget widget) throws UnifyException {
        Control control;
        if (widget instanceof Control && (control = (Control)widget).isLayoutColorMode()) {
            switch (control.getColorMode()) {
                case ERROR: {
                    writer.write(" err");
                    break;
                }
                case GRAYED: {
                    writer.write(" gray");
                    break;
                }
                case OK: {
                    writer.write(" ok");
                    break;
                }
                case WARNING: {
                    writer.write(" warn");
                    break;
                }
            }
        }
    }
}

