/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.panel;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.UserToken;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.ui.widget.Panel;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.panel.RemoteDocViewInfo;
import com.tcdng.unify.web.ui.widget.panel.RemoteDocViewPanel;
import com.tcdng.unify.web.ui.widget.writer.AbstractPanelWriter;

@Writes(value=RemoteDocViewPanel.class)
@Component(value="remotedocviewpanel-writer")
public class RemoteDocViewPanelWriter
extends AbstractPanelWriter {
    @Override
    protected void doWriteBehavior(ResponseWriter writer, Widget widget) throws UnifyException {
        RemoteDocViewPanel remoteDocViewPanel = (RemoteDocViewPanel)widget;
        writer.beginFunction("ux.loadRemoteDocViewPanel");
        writer.writeParam("pId", remoteDocViewPanel.getId());
        writer.writeParam("pWinPgNm", this.getResponseControllerWinId());
        RemoteDocViewInfo remoteDocViewInfo = remoteDocViewPanel.getRemoteDocViewInfo();
        writer.writeParam("pRemoteURL", remoteDocViewInfo.getRemoteDocUrl());
        UserToken userToken = this.getUserToken();
        writer.writeParam("pLoginId", userToken.getUserLoginId());
        writer.writeParam("pUserName", userToken.getUserName());
        if (StringUtils.isNotBlank((String)userToken.getRoleCode())) {
            writer.writeParam("pRoleCode", userToken.getRoleCode());
        }
        if (StringUtils.isNotBlank((String)userToken.getBranchCode())) {
            writer.writeParam("pBranchCode", userToken.getBranchCode());
        }
        if (StringUtils.isNotBlank((String)remoteDocViewInfo.getColorScheme())) {
            writer.writeParam("pColorScheme", remoteDocViewInfo.getColorScheme());
        }
        writer.writeParam("pGlobalFlag", userToken.isGlobalAccess());
        writer.endFunction();
    }

    @Override
    protected void doWriteInnerStructureAndContent(ResponseWriter writer, Panel panel) throws UnifyException {
        writer.write("<div id=\"").write(this.getResponseControllerWinId()).write("\" style=\"width:100%;height:100%;\">");
        writer.write("</div>");
    }

    private String getResponseControllerWinId() throws UnifyException {
        return "win_" + this.getPageManager().getPageName(this.getRequestContextUtil().getResponsePathParts().getControllerPathId());
    }
}

