/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.writer.panel;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Writes;
import com.tcdng.unify.web.ui.widget.Panel;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.panel.StretchPanel;
import com.tcdng.unify.web.ui.widget.writer.AbstractPanelWriter;

@Writes(value=StretchPanel.class)
@Component(value="stretchpanel-writer")
public class StretchPanelWriter
extends AbstractPanelWriter {
    @Override
    protected void doWriteStructureAndContent(ResponseWriter writer, Widget widget) throws UnifyException {
        StretchPanel panel = (StretchPanel)widget;
        writer.write("<div");
        this.writeTagId(writer, panel);
        this.writeTagStyleClass(writer, panel.getStyleClass());
        this.writeTagStyle(writer, "width:100%;height:100%;overflow:auto;");
        writer.write(">");
        this.writeInnerStructureAndContent(writer, panel);
        writer.write("</div>");
    }

    @Override
    public void writeInnerStructureAndContent(ResponseWriter writer, Panel panel) throws UnifyException {
        StretchPanel stretchPanel = (StretchPanel)panel;
        writer.write("<div id=\"").write(stretchPanel.getContentPageName());
        writer.write("\" style=\"width:100%;height:100%;display:none;\">");
        super.writeInnerStructureAndContent(writer, panel);
        writer.write("</div>");
    }

    @Override
    protected void doWriteBehavior(ResponseWriter writer, Widget widget) throws UnifyException {
        super.doWriteBehavior(writer, widget);
        StretchPanel panel = (StretchPanel)widget;
        writer.beginFunction("ux.rigStretchPanel");
        writer.writeParam("pId", panel.getId());
        writer.writeParam("pContId", panel.getContentPageName());
        writer.endFunction();
    }
}

